/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_10799;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8027;
import net.minecraft.class_8028;
import org.jetbrains.annotations.Nullable;

public final class SelectionWidget<T extends SelectionEntry<T>>
extends class_4264 {
    private static final class_2960 ARROW_UP = class_2960.method_60656((String)"transferable_list/move_up");
    private static final class_2960 ARROW_DOWN = class_2960.method_60656((String)"transferable_list/move_down");
    private static final int ARROW_UP_OFF_X = 18;
    private static final int ARROW_UP_OFF_Y = 5;
    private static final int ARROW_DOWN_OFF_X = 18;
    private static final int ARROW_DOWN_OFF_Y = 20;
    private static final int ENTRY_HEIGHT = 20;
    private final class_437 owner;
    private final class_2561 title;
    @Nullable
    private final Consumer<T> selectCallback;
    private final List<T> entries = new ArrayList<T>();
    @Nullable
    private T focused = null;
    @Nullable
    private T selected = null;
    private boolean extended = false;
    private int scrollOffset = 0;

    public SelectionWidget(class_437 owner, int x, int y, int width, class_2561 title, @Nullable Consumer<T> selectCallback) {
        super(x, y, width, 20, (class_2561)class_2561.method_43473());
        this.owner = owner;
        this.title = title;
        this.selectCallback = selectCallback;
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int fgColor;
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        int n = fgColor = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        if (this.selected != null) {
            boolean entryFocused = ((SelectionEntry)this.selected).method_25370();
            ((SelectionEntry)this.selected).focused = false;
            ((SelectionEntry)this.selected).render(graphics, this.method_46426(), this.method_46427(), this.field_22758, false, fgColor, this.field_22765);
            ((SelectionEntry)this.selected).focused = entryFocused;
        } else {
            class_327 font = class_310.method_1551().field_1772;
            graphics.method_27535(font, this.title, this.method_46426() + 6, this.method_46427() + (this.field_22759 - 8) / 2, fgColor | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
        }
        if (this.extended) {
            int boxHeight = Math.max(1, 20 * Math.min(this.entries.size(), 4)) + 2;
            graphics.method_25294(this.method_46426(), this.method_46427() + 20 - 1, this.method_46426() + this.field_22758, this.method_46427() + 20 + boxHeight - 1, -1);
            graphics.method_25294(this.method_46426() + 1, this.method_46427() + 20, this.method_46426() + this.field_22758 - 1, this.method_46427() + 20 + boxHeight - 2, -16777216);
            graphics.method_52706(class_10799.field_56883, ARROW_UP, this.method_46426() + this.field_22758 - 17 - 18, this.method_46427() + 6 - 5, 32, 32);
            T hoverEntry = this.getEntryAtPosition(mouseX, mouseY);
            for (int i = 0; i < 4; ++i) {
                int idx = i + this.scrollOffset;
                if (idx >= this.entries.size()) continue;
                int entryY = this.method_46427() + (i + 1) * 20;
                SelectionEntry entry = (SelectionEntry)this.entries.get(idx);
                entry.render(graphics, this.method_46426() + 1, entryY, this.field_22758 - 2, entry == hoverEntry, fgColor, this.field_22765);
            }
            if (this.entries.size() > 4) {
                float scale = 4.0f / (float)this.entries.size();
                int scrollY = this.method_46427() + (int)((float)(20 * this.scrollOffset) * scale) + 20;
                int barHeight = (int)(80.0f * scale + 1.0f);
                int scrollBotY = Math.min(scrollY + barHeight, this.method_46427() + 20 + boxHeight - 2);
                graphics.method_25294(this.method_46426() + this.field_22758 - 5, scrollY, this.method_46426() + this.field_22758 - 1, scrollBotY, -10066330);
                graphics.method_25294(this.method_46426() + this.field_22758 - 4, scrollY + 1, this.method_46426() + this.field_22758 - 2, scrollBotY - 1, -5592406);
            }
        } else {
            graphics.method_52706(class_10799.field_56883, ARROW_DOWN, this.method_46426() + this.field_22758 - 17 - 18, this.method_46427() + 6 - 20, 32, 32);
        }
    }

    public int method_25364() {
        if (this.extended) {
            return 20 * (Math.min(this.entries.size(), 4) + 1) + 1;
        }
        return 20;
    }

    public void method_25306(class_11907 input) {
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.field_22763 && event.comp_4798() >= (double)this.method_46426() && event.comp_4798() <= (double)(this.method_46426() + this.field_22758) && event.comp_4799() >= (double)this.method_46427() && event.comp_4799() <= (double)(this.method_46427() + this.method_25364())) {
            int maxX = this.method_46426() + this.field_22758 - (this.entries.size() > 4 ? 5 : 0);
            int maxY = this.method_46427() + 20 * Math.min(this.entries.size() + 1, 5);
            if (this.extended && event.comp_4798() < (double)maxX && event.comp_4799() > (double)(this.method_46427() + 20) && event.comp_4799() < (double)maxY) {
                this.setSelected(this.getEntryAtPosition(event.comp_4798(), event.comp_4799()), true);
            }
            if (event.comp_4799() < (double)(this.method_46427() + 20) && event.comp_4798() < (double)(this.method_46426() + this.field_22758) || event.comp_4798() < (double)maxX) {
                this.toggleExtended();
            }
            this.method_25354(class_310.method_1551().method_1483());
            return true;
        }
        this.extended = false;
        this.scrollOffset = 0;
        return super.method_25402(event, doubleClick);
    }

    public boolean method_25404(class_11908 event) {
        boolean hasFocused;
        boolean bl = hasFocused = this.extended && this.focused != null;
        if (this.field_22763 && this.field_22764 && (this.method_25370() || hasFocused) && event.method_74229()) {
            if (this.method_25370()) {
                this.toggleExtended();
            } else if (hasFocused) {
                this.setSelected(this.focused, true);
                this.toggleExtended();
            }
            this.method_25354(class_310.method_1551().method_1483());
            return true;
        }
        return false;
    }

    private void toggleExtended() {
        this.extended = !this.extended;
        this.scrollOffset = 0;
        if (this.extended && this.selected != null) {
            this.owner.method_25395(this.selected);
            this.scrollOffset = Math.min(this.entries.indexOf(this.selected), this.entries.size() - 4);
        } else if (!this.extended && this.focused != null) {
            this.focused = null;
            this.owner.method_25395((class_364)this);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        int maxY = this.method_46427() + 20 * Math.min(this.entries.size() + 1, 5);
        if (this.extended && mouseX >= (double)this.method_46426() && mouseX <= (double)(this.method_46426() + this.field_22758) && mouseY > (double)(this.method_46427() + 20) && mouseY < (double)maxY) {
            if (deltaY < 0.0 && this.scrollOffset < this.entries.size() - 4) {
                ++this.scrollOffset;
            } else if (deltaY > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean method_25405(double pMouseX, double pMouseY) {
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        return pMouseX >= (double)this.method_46426() && pMouseY >= (double)this.method_46427() && pMouseX < (double)(this.method_46426() + this.field_22758) && pMouseY < (double)(this.method_46427() + this.method_25364());
    }

    @Nullable
    private T getEntryAtPosition(double mouseX, double mouseY) {
        if (mouseX < (double)this.method_46426() || mouseX > (double)(this.method_46426() + this.field_22758) || mouseY < (double)(this.method_46427() + 20) || mouseY > (double)(this.method_46427() + 100)) {
            return null;
        }
        double posY = mouseY - (double)(this.method_46427() + 20);
        int idx = (int)(posY / 20.0) + this.scrollOffset;
        return (T)(idx < this.entries.size() ? (SelectionEntry)this.entries.get(idx) : null);
    }

    void focusAndScrollTo(T entry) {
        this.focused = entry;
        int idx = this.entries.indexOf(entry);
        if (idx < 0 || idx >= this.entries.size()) {
            return;
        }
        if (idx < this.scrollOffset) {
            this.scrollOffset = idx;
        } else if (idx > this.scrollOffset + 3) {
            this.scrollOffset = idx - 3;
        }
    }

    public void addEntry(T entry) {
        this.entries.add(entry);
        ((SelectionEntry)entry).captureOwner(this);
    }

    public void setSelected(@Nullable T selected, boolean notify) {
        this.selected = selected;
        if (notify && this.selectCallback != null && selected != null) {
            this.selectCallback.accept(selected);
        }
    }

    @Nullable
    public T getSelected() {
        return this.selected;
    }

    public Stream<T> stream() {
        return this.entries.stream();
    }

    protected void method_47399(class_6382 output) {
    }

    @Nullable
    public class_8016 method_48205(class_8023 event) {
        if (this.entries.isEmpty() || !this.extended || !(event instanceof class_8023.class_8024)) {
            return super.method_48205(event);
        }
        class_8028 dir = ((class_8023.class_8024)event).comp_1191();
        if (dir.method_48237() == class_8027.field_41822) {
            return null;
        }
        if (this.method_25370() && this.focused != null) {
            return class_8016.method_48193(this.focused);
        }
        return switch (dir) {
            case class_8028.field_41826 -> class_8016.method_48193((class_364)((class_364)this.entries.getLast()));
            case class_8028.field_41827 -> class_8016.method_48193((class_364)((class_364)this.entries.getFirst()));
            default -> throw new IllegalStateException("Unreachable");
        };
    }

    @Nullable
    public T getFocusNeighbour(T entry, class_8028 dir) {
        int idx = this.entries.indexOf(entry);
        return (T)(switch (dir) {
            case class_8028.field_41827 -> {
                if (idx < this.entries.size() - 1) {
                    yield (SelectionEntry)this.entries.get(idx + 1);
                }
                yield (SelectionEntry)this.entries.getFirst();
            }
            case class_8028.field_41826 -> {
                if (idx > 0) {
                    yield (SelectionEntry)this.entries.get(idx - 1);
                }
                yield (SelectionEntry)this.entries.getLast();
            }
            default -> null;
        });
    }

    public static class SelectionEntry<T extends SelectionEntry<T>>
    implements class_364 {
        private final class_2561 message;
        @Nullable
        private SelectionWidget<T> owner = null;
        boolean focused = false;

        public SelectionEntry(class_2561 message) {
            this.message = message;
        }

        public void render(class_332 graphics, int x, int y, int width, boolean hovered, int fgColor, float alpha) {
            if (hovered || this.focused) {
                graphics.method_25294(x, y, x + width, y + 20, -6250336);
            }
            class_327 font = class_310.method_1551().field_1772;
            class_5481 text = class_2477.method_10517().method_30934(class_5348.method_29433((class_5348[])new class_5348[]{font.method_1714((class_5348)this.message, width - 12)}));
            graphics.method_35720(font, text, x + 6, y + 6, fgColor | class_3532.method_15386((float)(alpha * 255.0f)) << 24);
        }

        public boolean method_25404(class_11908 event) {
            if (this.method_25370()) {
                return Objects.requireNonNull(this.owner).method_25404(event);
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public class_8016 method_48205(class_8023 event) {
            SelectionEntry entry;
            if (!this.method_25370() || !(event instanceof class_8023.class_8024)) return null;
            class_8023.class_8024 class_80242 = (class_8023.class_8024)event;
            try {
                class_8028 class_80282;
                class_8028 dir = class_80282 = class_80242.comp_1191();
                entry = Objects.requireNonNull(this.owner).getFocusNeighbour(this, dir);
                if (entry == null) return null;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return class_8016.method_48193((class_364)entry);
        }

        public final void method_25365(boolean focused) {
            this.focused = focused;
            if (focused) {
                Objects.requireNonNull(this.owner).focusAndScrollTo(this);
            }
        }

        public final boolean method_25370() {
            return this.focused;
        }

        void captureOwner(SelectionWidget<T> owner) {
            this.owner = owner;
        }
    }
}

