/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.util;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import xfacthd.atlasviewer.client.screen.state.FloatBlitRenderState;
import xfacthd.atlasviewer.client.screen.state.FloatColoredRectangleRenderState;
import xfacthd.atlasviewer.platform.Services;

public final class ClientUtils {
    @Nullable
    private static Boolean arbClearTextureSupported = null;

    public static boolean isArbClearTextureSupported() {
        if (arbClearTextureSupported == null) {
            GLCapabilities capabilities = GL.getCapabilities();
            arbClearTextureSupported = capabilities.GL_ARB_clear_texture;
        }
        return arbClearTextureSupported;
    }

    public static int getWrappedHeight(class_327 font, class_5348 text, int width) {
        int n = font.method_1728(text, width).size();
        Objects.requireNonNull(font);
        return n * 9;
    }

    public static void drawColoredBox(class_332 graphics, int x, int y, int w, int h, int color) {
        graphics.method_48196(class_10799.field_56879, x, y, x + 1, y + h, color);
        graphics.method_48196(class_10799.field_56879, x + w - 1, y, x + w, y + h, color);
        graphics.method_48196(class_10799.field_56879, x, y, x + w, y + 1, color);
        graphics.method_48196(class_10799.field_56879, x, y + h - 1, x + w, y + h, color);
    }

    public static void drawColoredBox(class_332 graphics, float x, float y, float w, float h, int color) {
        ClientUtils.fill(graphics, class_10799.field_56879, x, y, x + 1.0f, y + h, color);
        ClientUtils.fill(graphics, class_10799.field_56879, x + w - 1.0f, y, x + w, y + h, color);
        ClientUtils.fill(graphics, class_10799.field_56879, x, y, x + w, y + 1.0f, color);
        ClientUtils.fill(graphics, class_10799.field_56879, x, y + h - 1.0f, x + w, y + h, color);
    }

    public static void fill(class_332 graphics, RenderPipeline pipeline, float minX, float minY, float maxX, float maxY, int color) {
        ClientUtils.fill(graphics, pipeline, minX, minY, maxX, maxY, color, color);
    }

    public static void fill(class_332 graphics, RenderPipeline pipeline, float minX, float minY, float maxX, float maxY, int colorOne, int colorTwo) {
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)graphics.method_51448());
        class_8030 scissorRect = Services.PLATFORM.peekScissorState(graphics);
        class_8030 bounds = ClientUtils.getBounds(minX, minY, maxX, maxY, pose, scissorRect);
        Services.PLATFORM.submitCustomGuiRenderState(graphics, new FloatColoredRectangleRenderState(pipeline, pose, minX, minY, maxX, maxY, colorOne, colorTwo, scissorRect, bounds));
    }

    public static void blitSpecial(class_332 graphics, RenderPipeline pipeline, class_11231 textureSetup, float minX, float minY, float maxX, float maxY, float minU, float maxU, float minV, float maxV, int color) {
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)graphics.method_51448());
        class_8030 scissorRect = Services.PLATFORM.peekScissorState(graphics);
        class_8030 bounds = ClientUtils.getBounds(minX, minY, maxX, maxY, pose, scissorRect);
        Services.PLATFORM.submitCustomGuiRenderState(graphics, new FloatBlitRenderState(pipeline, textureSetup, pose, minX, minY, maxX, maxY, minU, maxU, minV, maxV, color, scissorRect, bounds));
    }

    @Nullable
    public static class_8030 getBounds(float x0, float y0, float x1, float y1, Matrix3x2f pose, @javax.annotation.Nullable class_8030 scissorRect) {
        int x0i = class_3532.method_15375((float)x0);
        int y0i = class_3532.method_15375((float)y0);
        int x1i = class_3532.method_15386((float)x1);
        int y1i = class_3532.method_15386((float)y1);
        class_8030 rect = new class_8030(x0i, y0i, x1i - x0i, y1i - y0i).method_71523(pose);
        return scissorRect != null ? scissorRect.method_49701(rect) : rect;
    }

    public static void downloadTexture(GpuTexture srcTexture, int mipLevel, Consumer<class_1011> imageConsumer) {
        GpuDevice device = RenderSystem.getDevice();
        CommandEncoder cmdEncoder = device.createCommandEncoder();
        int width = srcTexture.getWidth(mipLevel);
        int height = srcTexture.getHeight(mipLevel);
        int pixSize = srcTexture.getFormat().pixelSize();
        int bufSize = width * height * pixSize;
        GpuBuffer buffer = device.createBuffer(() -> "Texture output buffer", 9, bufSize);
        Services.PLATFORM.fixMipLevelTexParams(srcTexture);
        cmdEncoder.copyTextureToBuffer(srcTexture, buffer, 0, () -> {
            try (GpuBuffer.MappedView bufView = cmdEncoder.mapBuffer(buffer, true, false);
                 class_1011 destImage = new class_1011(width, height, false);){
                ByteBuffer data = bufView.data();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int pixel = data.getInt((x + y * width) * pixSize);
                        destImage.method_4305(x, y, pixel);
                    }
                }
                imageConsumer.accept(destImage);
            }
            buffer.close();
        }, mipLevel);
    }

    private ClientUtils() {
    }
}

