/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10799;
import net.minecraft.class_11697;
import net.minecraft.class_11719;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_7764;
import org.jetbrains.annotations.Nullable;
import xfacthd.atlasviewer.AtlasViewer;
import xfacthd.atlasviewer.client.screen.AtlasScreen;
import xfacthd.atlasviewer.client.screen.AtlasViewerScreen;
import xfacthd.atlasviewer.client.screen.stacking.IStackedScreen;
import xfacthd.atlasviewer.client.screen.widget.AtlasLoadTable;
import xfacthd.atlasviewer.client.screen.widget.CloseButton;
import xfacthd.atlasviewer.platform.Services;

public final class AtlasInfoScreen
extends AtlasViewerScreen
implements IStackedScreen {
    private static final class_2561 TITLE = class_2561.method_43471((String)"title.atlasviewer.atlasinfo");
    private static final class_2561 MSG_HW_DEPEND = class_2561.method_43471((String)"msg.atlasviewer.atlas_hw_dependent");
    private static final class_2561 MSG_SPRITES_BY_MAX_MIP = class_2561.method_43471((String)"msg.atlasviewer.atlas_sprites_by_max_mip");
    private static final class_2561 CHAR_ARROW = class_2561.method_43470((String)"\u21b3").method_27694(s -> s.method_27704((class_11719)new class_11719.class_11721(AtlasViewer.rl("arrow"))));
    private static final class_2561 LABEL_NAME = class_2561.method_43471((String)"label.atlasviewer.atlas_name");
    private static final class_2561 LABEL_SIZE = class_2561.method_43471((String)"label.atlasviewer.atlas_size");
    private static final class_2561 LABEL_MAX_SIZE = class_2561.method_43469((String)"label.atlasviewer.atlas_max_size", (Object[])new Object[]{class_2561.method_43470((String)"\u26a0").method_27694(s -> s.method_36139(0xFF7700))});
    private static final class_2561 LABEL_MIP_LEVELS = class_2561.method_43471((String)"label.atlasviewer.atlas_mip_levels");
    private static final class_2561 LABEL_SPRITES = class_2561.method_43471((String)"label.atlasviewer.atlas_sprite_count");
    private static final class_2561 LABEL_SPRITES_BY_MAX_MIP = class_2561.method_43469((String)"label.atlasviewer.atlas_sprite_count_by_max_mip", (Object[])new Object[]{CHAR_ARROW, class_2561.method_43470((String)"i").method_27692(class_124.field_1078)});
    private static final class_2561 LABEL_PERCENT_FILLED = class_2561.method_43471((String)"label.atlasviewer.atlas_percent_filled");
    private static final Label[] LABELS = new Label[]{new Label(LABEL_NAME), new Label(LABEL_SIZE), new Label(LABEL_MAX_SIZE), new Label(LABEL_MIP_LEVELS, screen -> screen.atlasInfo.mipped), new Label(LABEL_SPRITES), new Label(LABEL_SPRITES_BY_MAX_MIP, screen -> screen.atlasInfo.mipped), new Label(LABEL_PERCENT_FILLED)};
    private static final int WIDTH = 400;
    private static final int PADDING = 5;
    private static final int LINE_HEIGHT = 12;
    private static final int TITLE_Y = 10;
    private static final int TEXT_X = 10;
    private static final int FIRST_LINE_Y = 30;
    private static final int TABLE_WIDTH = 380;
    private static final int CLOSE_SIZE = 12;
    private final AtlasInfo atlasInfo;
    private final class_2561 atlasSizeText;
    private final class_2561 atlasMaxSizeText;
    private final class_2561 atlasMipLevelText;
    private final class_2561 spriteCountText;
    @Nullable
    private final class_2561 countsByMip;
    private final class_2561 percentFilledText;
    private final class_2561 tableHeader;
    private int imageHeight;
    private int xLeft;
    private int yTop;
    private int valueX;
    private int tableTitleY;

    public AtlasInfoScreen(AtlasInfo atlasInfo) {
        super(TITLE);
        this.atlasInfo = atlasInfo;
        this.atlasSizeText = class_2561.method_43469((String)"value.atlasviewer.size", (Object[])new Object[]{atlasInfo.width, atlasInfo.height});
        this.atlasMaxSizeText = class_2561.method_43469((String)"value.atlasviewer.size", (Object[])new Object[]{atlasInfo.maxSize, atlasInfo.maxSize});
        this.atlasMipLevelText = class_2561.method_43470((String)Integer.toString(atlasInfo.mipLevels));
        this.spriteCountText = class_2561.method_43470((String)Integer.toString(atlasInfo.spriteCount));
        this.countsByMip = atlasInfo.mipped ? class_2561.method_43469((String)"value.atlasviewer.atlas_sprites_by_max_mip", (Object[])Arrays.stream(atlasInfo.spriteCountByMaxMipLevel).mapToObj(String::valueOf).map(v -> class_2561.method_43470((String)v).method_27696(class_2583.field_24360.method_36139(0x666666))).toArray()) : null;
        this.percentFilledText = class_2561.method_43470((String)"%.1f %%".formatted(Float.valueOf(atlasInfo.percentFilled * 100.0f)));
        int nsCount = atlasInfo.fillStats.size();
        this.tableHeader = nsCount == 1 ? class_2561.method_43469((String)"label.atlasviewer.atlas_percent_filled_by_ns_single", (Object[])new Object[]{CHAR_ARROW}) : class_2561.method_43469((String)"label.atlasviewer.atlas_percent_filled_by_ns", (Object[])new Object[]{CHAR_ARROW, nsCount});
    }

    protected void method_25426() {
        int labelLen = 0;
        int labelHeight = 0;
        for (int i = 0; i < LABELS.length; ++i) {
            Label label = LABELS[i];
            if (!label.active.test(this)) continue;
            labelLen = Math.max(labelLen, this.field_22793.method_27525((class_5348)label.text));
            labelHeight += 12;
        }
        this.valueX = 10 + labelLen + 5;
        this.imageHeight = 30 + labelHeight + 12 + 56 + 10;
        this.xLeft = this.field_22789 / 2 - 200;
        this.yTop = this.field_22790 / 2 - this.imageHeight / 2;
        this.tableTitleY = this.yTop + 30 + labelHeight;
        this.method_37063((class_364)new AtlasLoadTable(this.xLeft + 10, this.tableTitleY + 12, 380, this.atlasInfo));
        this.method_37063((class_364)new CloseButton(this.xLeft + 400 - 5 - 12, this.yTop + 5, this));
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_57734(graphics);
        graphics.method_52706(class_10799.field_56883, AtlasScreen.BACKGROUND_LOC, this.xLeft, this.yTop, 400, this.imageHeight);
        graphics.method_51439(this.field_22793, this.field_22785, this.xLeft + 10, this.yTop + 10, -12566464, false);
        int y = this.yTop + 30;
        y = this.drawLine(graphics, LABEL_NAME, (class_2561)class_2561.method_43470((String)this.atlasInfo.name), y);
        y = this.drawLine(graphics, LABEL_SIZE, this.atlasSizeText, y);
        y = this.drawLine(graphics, LABEL_MAX_SIZE, this.atlasMaxSizeText, y);
        if (this.atlasInfo.mipped) {
            y = this.drawLine(graphics, LABEL_MIP_LEVELS, this.atlasMipLevelText, y);
        }
        y = this.drawLine(graphics, LABEL_SPRITES, this.spriteCountText, y);
        if (this.atlasInfo.mipped) {
            y = this.drawLine(graphics, LABEL_SPRITES_BY_MAX_MIP, Objects.requireNonNull(this.countsByMip), y);
        }
        y = this.drawLine(graphics, LABEL_PERCENT_FILLED, this.percentFilledText, y);
        graphics.method_51439(this.field_22793, this.tableHeader, this.xLeft + 10, this.tableTitleY, -12566464, false);
        int len = this.field_22793.method_27525((class_5348)LABEL_MAX_SIZE);
        int minY = this.yTop + 30 + 24;
        if (mouseX >= this.xLeft + 10 && mouseX < this.xLeft + 10 + len && mouseY >= minY) {
            Objects.requireNonNull(this.field_22793);
            if (mouseY <= minY + 9) {
                this.setTooltipForNextFrame(graphics, MSG_HW_DEPEND, mouseX, mouseY);
            }
        }
        if (this.atlasInfo.mipped) {
            len = this.field_22793.method_27525((class_5348)LABEL_SPRITES_BY_MAX_MIP);
            minY = this.yTop + 30 + 60;
            if (mouseX >= this.xLeft + 10 && mouseX < this.xLeft + 10 + len && mouseY >= minY) {
                Objects.requireNonNull(this.field_22793);
                if (mouseY <= minY + 9) {
                    this.setTooltipForNextFrame(graphics, MSG_SPRITES_BY_MAX_MIP, mouseX, mouseY);
                }
            }
        }
    }

    private int drawLine(class_332 graphics, class_2561 label, class_2561 value, int y) {
        graphics.method_51439(this.field_22793, label, this.xLeft + 10, y, -12566464, false);
        graphics.method_51439(this.field_22793, value, this.xLeft + this.valueX, y, -12566464, false);
        return y + 12;
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (event.method_74245() == 0 && (event.comp_4798() < (double)this.xLeft || event.comp_4799() < (double)this.yTop || event.comp_4798() > (double)(this.xLeft + 400) || event.comp_4799() > (double)(this.yTop + this.imageHeight))) {
            this.method_25419();
            return true;
        }
        return super.method_25402(event, doubleClick);
    }

    public void method_25419() {
        Services.PLATFORM.popScreenLayer();
    }

    public static AtlasInfo computeInfo(class_11697.class_7772 atlasEntry, Collection<class_1058> sprites) {
        Map<String, Integer> areaByNamespace = sprites.stream().map(class_1058::method_45851).map(c -> ObjectIntPair.of((Object)c.method_45816().method_12836(), (int)(c.method_45807() * c.method_45815()))).collect(Collectors.groupingBy(Pair::first, Collectors.summingInt(ObjectIntPair::rightInt)));
        Object2IntLinkedOpenHashMap countByNamespace = new Object2IntLinkedOpenHashMap();
        sprites.stream().map(class_1058::method_45851).map(class_7764::method_45816).map(class_2960::method_12836).forEach(arg_0 -> AtlasInfoScreen.lambda$computeInfo$7((Object2IntMap)countByNamespace, arg_0));
        int[] spritesByMaxMip = new int[5];
        sprites.forEach(sprite -> {
            int maxLevel;
            class_7764 contents = sprite.method_45851();
            int lowestOne = Math.min(Integer.lowestOneBit(contents.method_45807()), Integer.lowestOneBit(contents.method_45815()));
            int n = maxLevel = Math.min(class_3532.method_15351((int)lowestOne), 4);
            spritesByMaxMip[n] = spritesByMaxMip[n] + 1;
        });
        class_1059 atlas = atlasEntry.comp_1051();
        int width = atlas.method_49713();
        int height = atlas.method_49714();
        int area = width * height;
        int areaFilled = areaByNamespace.values().stream().mapToInt(Integer::intValue).sum();
        float filled = (float)areaFilled / (float)area;
        ArrayList<FillStat> fillStats = new ArrayList<FillStat>();
        areaByNamespace.forEach((arg_0, arg_1) -> AtlasInfoScreen.lambda$computeInfo$9(area, areaFilled, fillStats, (Object2IntMap)countByNamespace, arg_0, arg_1));
        return new AtlasInfo(atlasEntry.comp_4557().comp_4553().toString(), atlasEntry.comp_4557().comp_4555(), atlas.method_45850(), width, height, atlas.atlasviewer$getMipLevel(), sprites.size(), spritesByMaxMip, filled, fillStats);
    }

    private static /* synthetic */ void lambda$computeInfo$9(int area, int areaFilled, List fillStats, Object2IntMap countByNamespace, String namespace, Integer value) {
        float namespaceArea = value.intValue();
        float percentOfTotal = namespaceArea / (float)area;
        float percentOfFilled = namespaceArea / (float)areaFilled;
        fillStats.add(new FillStat(namespace, countByNamespace.getInt((Object)namespace), percentOfTotal, percentOfFilled));
    }

    private static /* synthetic */ void lambda$computeInfo$7(Object2IntMap countByNamespace, String s) {
        countByNamespace.computeInt((Object)s, (ns, count) -> (count != null ? count : 0) + 1);
    }

    public record AtlasInfo(String name, boolean mipped, int maxSize, int width, int height, int mipLevels, int spriteCount, int[] spriteCountByMaxMipLevel, float percentFilled, List<FillStat> fillStats) {
    }

    private record Label(class_2561 text, Predicate<AtlasInfoScreen> active) {
        public Label(class_2561 text) {
            this(text, screen -> true);
        }
    }

    public record FillStat(String namespace, int count, float percentOfTotal, float percentOfFilled) {
    }
}

