/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen;

import com.mojang.blaze3d.textures.GpuTextureView;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_10725;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11697;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_327;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_7764;
import net.minecraft.class_7948;
import net.minecraft.class_8000;
import net.minecraft.class_8689;
import net.minecraft.class_8690;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import xfacthd.atlasviewer.AtlasViewer;
import xfacthd.atlasviewer.client.api.SourceAwareness;
import xfacthd.atlasviewer.client.screen.AtlasScreen;
import xfacthd.atlasviewer.client.screen.AtlasViewerScreen;
import xfacthd.atlasviewer.client.screen.MessageScreen;
import xfacthd.atlasviewer.client.screen.stacking.IStackedScreen;
import xfacthd.atlasviewer.client.screen.widget.BackgroundSwitchButton;
import xfacthd.atlasviewer.client.screen.widget.CloseButton;
import xfacthd.atlasviewer.client.screen.widget.DiscreteSliderButton;
import xfacthd.atlasviewer.client.util.ClientUtils;
import xfacthd.atlasviewer.client.util.FixedTooltipPositioner;
import xfacthd.atlasviewer.client.util.SpriteSourceManager;
import xfacthd.atlasviewer.client.util.TextLine;
import xfacthd.atlasviewer.client.util.TooltipSeparator;
import xfacthd.atlasviewer.platform.Services;

public final class SpriteInfoScreen
extends AtlasViewerScreen
implements IStackedScreen {
    private static final class_2561 TITLE = class_2561.method_43471((String)"title.atlasviewer.spriteinfo");
    private static final class_2561 CHAR_INFO = class_2561.method_43470((String)"i").method_27692(class_124.field_1078);
    private static final class_2561 LABEL_NAME = class_2561.method_43471((String)"label.atlasviewer.spriteinfo.name");
    private static final class_2561 LABEL_POSITION = class_2561.method_43471((String)"label.atlasviewer.spriteinfo.position");
    private static final class_2561 LABEL_SIZE = class_2561.method_43471((String)"label.atlasviewer.spriteinfo.size");
    private static final class_2561 LABEL_SOURCEPACK = class_2561.method_43471((String)"label.atlasviewer.spriteinfo.sourcepack");
    private static final class_2561 LABEL_READERPACK = class_2561.method_43469((String)"label.atlasviewer.spriteinfo.readerpack", (Object[])new Object[]{CHAR_INFO});
    private static final class_2561 LABEL_READERTYPE = class_2561.method_43471((String)"label.atlasviewer.spriteinfo.readertype");
    private static final class_2561 LABEL_MAX_MIP_LEVEL = class_2561.method_43469((String)"label.atlasviewer.spriteinfo.max_mip_level", (Object[])new Object[]{CHAR_INFO});
    private static final class_2561 LABEL_ANIMATED = class_2561.method_43471((String)"label.atlasviewer.spriteinfo.animated");
    private static final class_2561 LABEL_FRAMECOUNT = class_2561.method_43471((String)"label.atlasviewer.spriteinfo.frames");
    private static final class_2561 LABEL_INTERPOLATED = class_2561.method_43471((String)"label.atlasviewer.spriteinfo.interpolated");
    private static final class_2561 LABEL_FRAMETIME = class_2561.method_43471((String)"label.atlasviewer.spriteinfo.frametime");
    private static final class_2561 LABEL_GUI_SPRITE_TYPE = class_2561.method_43471((String)"label.atlasviewer.spriteinfo.gui_type");
    private static final class_2561 LABEL_GUI_SPRITE_SIZE = class_2561.method_43471((String)"label.atlasviewer.spriteinfo.gui_size");
    private static final class_2561 LABEL_GUI_SPRITE_NINESLICE_BORDER = class_2561.method_43471((String)"label.atlasviewer.spriteinfo.gui_nineslice_border");
    private static final List<Label> LABELS = List.of(new Label(LABEL_NAME), new Label(LABEL_POSITION), new Label(LABEL_SIZE), new Label(LABEL_SOURCEPACK), new Label(LABEL_READERPACK), new Label(LABEL_READERTYPE), new Label(LABEL_MAX_MIP_LEVEL, screen -> screen.mipped), new Label(LABEL_ANIMATED), new Label(LABEL_FRAMECOUNT, screen -> screen.animated), new Label(LABEL_INTERPOLATED, screen -> screen.animated), new Label(LABEL_FRAMETIME, screen -> screen.animated), new Label(LABEL_GUI_SPRITE_TYPE, screen -> screen.guiSprite), new Label(LABEL_GUI_SPRITE_SIZE, screen -> screen.guiSprite && Objects.requireNonNull(screen.guiScaling).method_52876() != class_8690.class_8695.field_45656), new Label(LABEL_GUI_SPRITE_NINESLICE_BORDER, screen -> screen.guiSprite && Objects.requireNonNull(screen.guiScaling).method_52876() == class_8690.class_8695.field_45658));
    private static final class_2561 VALUE_TRUE = class_2561.method_43471((String)"value.atlasviewer.true").method_27696(class_2583.field_24360.method_36139(53248));
    private static final class_2561 VALUE_FALSE = class_2561.method_43471((String)"value.atlasviewer.false").method_27696(class_2583.field_24360.method_36139(0xD00000));
    private static final class_2561 VALUE_FRAMETIME_MIXED = class_2561.method_43471((String)"value.atlasviewer.frametime_mixed");
    private static final class_2561 VALUE_UNKNOWN_PACK = class_2561.method_43471((String)"value.atlasviewer.unknown_pack").method_27694(s -> s.method_36139(0xD00000));
    private static final class_2561 TITLE_EXPORT = class_2561.method_43471((String)"btn.atlasviewer.export_sprite");
    private static final class_2561 TITLE_EXPORT_MIPPED = class_2561.method_43471((String)"btn.atlasviewer.export_mipped_sprite");
    private static final class_2561 MSG_EXPORT_DETAILS = class_2561.method_43471((String)"msg.atlasviewer.export_sprite.detail");
    private static final class_2561 MSG_EXPORT_SUCCESS = class_2561.method_43471((String)"msg.atlasviewer.export_sprite_success");
    private static final class_2561 MSG_EXPORT_ERROR = class_2561.method_43471((String)"msg.atlasviewer.export_sprite_error");
    private static final class_2561 TOOLTIP_READERPACK = class_2561.method_43471((String)"tooltip.atlasviewer.reader_pack");
    private static final class_2561 TOOLTIP_MAX_MIP_LEVEL = class_2561.method_43471((String)"tooltip.atlasviewer.sprite.max_mip_level");
    private static final class_2561 TOOLTIP_MIPMAP_DISABLED = class_2561.method_43471((String)"tooltip.atlasviewer.sprite.mipmap_disabled");
    private static final class_2561 TOOLTIP_MIPMAP_FULL = class_2561.method_43471((String)"tooltip.atlasviewer.sprite.mipmap_full");
    private static final class_2561 FULL_TYPE_PLACEHOLDER = class_2561.method_43469((String)"value.atlasviewer.source_tooltip.hold_to_show", (Object[])new Object[]{class_3675.method_15985((class_11908)new class_11908(340, -1, 0)).method_27445()}).method_27692(class_124.field_1065);
    private static final class_8000 PACK_LIST_POSITIONER = new FixedTooltipPositioner();
    private static final int WIDTH = 400;
    private static final int PADDING = 5;
    private static final int LABEL_X = 148;
    private static final int SPRITE_Y = 25;
    private static final int LINE_HEIGHT = 12;
    private static final int EXPORT_WIDTH = 120;
    private static final int EXPORT_HEIGHT = 20;
    private static final int MIP_LEVEL_WIDTH = 120;
    private static final int MIP_LEVEL_HEIGHT = 20;
    private static final int CLOSE_SIZE = 12;
    private static final int SPRITE_SIZE = 128;
    private static final int FOOTER_HEIGHT = 40;
    private static final int MIN_HEIGHT = 193;
    private static final int LINE_NAME = 0;
    private static final int LINE_POSITION = 1;
    private static final int LINE_SIZE = 2;
    private static final int LINE_SOURCEPACK = 3;
    private static final int LINE_READERPACK = 4;
    private static final int LINE_READERTYPE = 5;
    private static final int LINE_MAX_MIP_LEVEL = 6;
    private final class_11697.class_7772 atlas;
    private final class_1058 sprite;
    private final class_7764 contents;
    private final boolean mipped;
    private final boolean animated;
    private final boolean guiSprite;
    private final List<String> sourceNames;
    @Nullable
    private final String primarySource;
    @Nullable
    private final class_7764.class_5790 animation;
    private final int animFrameTime;
    @Nullable
    private final class_8690 guiScaling;
    private final BackgroundSwitchButton.Type background;
    private int imageHeight;
    private int xLeft;
    private int yTop;
    private int valueX;
    private @UnknownNullability class_4185 btnExport;
    private @UnknownNullability class_4185 btnExportMipped;
    private @UnknownNullability TextLine spriteName;
    private @UnknownNullability class_2561 spritePosText;
    private @UnknownNullability class_2561 spriteSizeText;
    private @UnknownNullability TextLine primarySourceName;
    private @UnknownNullability SourcePackList sourceNameTooltip;
    private @UnknownNullability SpriteSourceInfo sourceInfo;
    private @UnknownNullability class_2561 maxMipLevel;
    private @UnknownNullability class_2561 maxMipLevelTooltip;
    private @UnknownNullability class_2561 animatedText;
    private @UnknownNullability class_2561 framesText;
    private @UnknownNullability class_2561 interpText;
    private @UnknownNullability class_2561 frameTimeText;
    private @UnknownNullability class_2561 guiSpriteTypeText;
    private @UnknownNullability class_2561 guiSpriteSizeText;
    private @UnknownNullability class_2561 guiSpriteNinesliceBorderText;
    private int currentMipLevel;

    public SpriteInfoScreen(class_11697.class_7772 atlas, class_1058 sprite, int currentMipLevel, BackgroundSwitchButton.Type background) {
        super(TITLE);
        this.atlas = atlas;
        this.sprite = sprite;
        this.contents = sprite.method_45851();
        this.mipped = atlas.comp_4557().comp_4555();
        this.guiSprite = atlas.comp_4557().comp_4554().equals((Object)class_10725.field_56385);
        this.background = background;
        this.sourceNames = this.collectSourcePackNames();
        this.primarySource = this.sourceNames.isEmpty() ? null : this.sourceNames.getFirst();
        this.animation = this.contents.atlasviewer$getAnimatedTexture();
        this.animated = this.animation != null;
        this.animFrameTime = this.getAnimationFrameTime();
        this.guiScaling = this.guiSprite ? SpriteInfoScreen.getGuiScaling(sprite) : null;
        this.currentMipLevel = currentMipLevel;
    }

    protected void method_25426() {
        int labelLen = 0;
        int labelHeight = 0;
        for (Label label : LABELS) {
            if (!label.active.test(this)) continue;
            labelLen = Math.max(labelLen, this.field_22793.method_27525((class_5348)label.text));
            labelHeight += 12;
        }
        this.valueX = 148 + labelLen + 5;
        this.imageHeight = Math.max(193, 25 + labelHeight + 40);
        this.xLeft = this.field_22789 / 2 - 200;
        this.yTop = this.field_22790 / 2 - this.imageHeight / 2;
        DiscreteSliderButton mipLevelSlider = (DiscreteSliderButton)this.method_37063((class_364)new DiscreteSliderButton(this.xLeft + 10, this.yTop + this.imageHeight - 10 - 20, 120, 20, "btn.atlasviewer.mip_level", this.currentMipLevel, this.atlas.comp_1051().atlasviewer$getMipLevel(), this::selectMipLevel));
        this.btnExport = class_4185.method_46430((class_2561)TITLE_EXPORT, this::exportSprite).method_46433(this.xLeft + 400 - 10 - 120, this.yTop + this.imageHeight - 10 - 20).method_46437(120, 20).method_46431();
        this.method_37063((class_364)this.btnExport);
        this.btnExportMipped = class_4185.method_46430((class_2561)TITLE_EXPORT_MIPPED, this::exportSpriteMipped).method_46433(this.xLeft + 400 - 20 - 240, this.yTop + this.imageHeight - 10 - 20).method_46437(120, 20).method_46431();
        this.method_37063((class_364)this.btnExportMipped);
        mipLevelSlider.field_22763 = this.atlas.comp_1051().atlasviewer$getMipLevel() > 0;
        this.btnExportMipped.field_22763 = this.currentMipLevel > 0;
        this.method_37063((class_364)new CloseButton(this.xLeft + 400 - 5 - 12, this.yTop + 5, this));
        int maxValueLen = 390 - this.valueX;
        this.spriteName = TextLine.of(this.contents.method_45816().toString(), this.field_22793, maxValueLen);
        this.spritePosText = class_2561.method_43469((String)"value.atlasviewer.position", (Object[])new Object[]{this.sprite.method_35806(), this.sprite.method_35807()});
        this.spriteSizeText = class_2561.method_43469((String)"value.atlasviewer.size", (Object[])new Object[]{this.contents.method_45807(), this.contents.method_45815()});
        this.primarySourceName = this.primarySource != null && !this.primarySource.isEmpty() ? TextLine.of(this.primarySource, this.field_22793, maxValueLen) : new TextLine(VALUE_UNKNOWN_PACK);
        this.sourceNameTooltip = this.makeTooltipList();
        this.sourceInfo = this.makeSourceInfo();
        if (this.mipped) {
            this.maxMipLevel = this.calculateMaxMipLevel();
        }
        if (this.animated) {
            this.animatedText = VALUE_TRUE;
            this.framesText = class_2561.method_43470((String)String.valueOf(this.contents.atlasviewer$callGetFrameCount()));
            boolean interp = Objects.requireNonNull(this.animation).atlasviewer$getInterpolateFrames();
            class_2561 class_25612 = this.interpText = interp ? VALUE_TRUE : VALUE_FALSE;
            this.frameTimeText = this.animFrameTime == -1 ? VALUE_FRAMETIME_MIXED : class_2561.method_43470((String)(this.animFrameTime + (this.animFrameTime == 1 ? " tick" : " ticks")));
        } else {
            this.animatedText = VALUE_FALSE;
        }
        if (this.guiSprite) {
            this.guiSpriteTypeText = class_2561.method_43471((String)("value.atlasviewer.spriteinfo.gui_sprite_type." + Objects.requireNonNull(this.guiScaling).method_52876().method_15434()));
            class_8690 class_86902 = this.guiScaling;
            Objects.requireNonNull(class_86902);
            class_8690 class_86903 = class_86902;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_8690.class_8694.class, class_8690.class_8691.class}, (Object)class_86903, n)) {
                case 0: {
                    class_8690.class_8694 tile = (class_8690.class_8694)class_86903;
                    this.guiSpriteSizeText = class_2561.method_43469((String)"value.atlasviewer.size", (Object[])new Object[]{tile.comp_1644(), tile.comp_1645()});
                    break;
                }
                case 1: {
                    class_8690.class_8691 nineSlice = (class_8690.class_8691)class_86903;
                    this.guiSpriteSizeText = class_2561.method_43469((String)"value.atlasviewer.size", (Object[])new Object[]{nineSlice.comp_1637(), nineSlice.comp_1638()});
                    class_8690.class_8691.class_8692 border = nineSlice.comp_1639();
                    if (border.comp_1641() == border.comp_1643() && border.comp_1641() == border.comp_1640() && border.comp_1641() == border.comp_1642()) {
                        this.guiSpriteNinesliceBorderText = class_2561.method_43470((String)(border.comp_1641() + "px"));
                        break;
                    }
                    this.guiSpriteNinesliceBorderText = class_2561.method_43469((String)"value.atlasviewer.spriteinfo.gui_nineslice_border", (Object[])new Object[]{border.comp_1641(), border.comp_1643(), border.comp_1640(), border.comp_1642()});
                    break;
                }
            }
        }
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_57734(graphics);
        graphics.method_52706(class_10799.field_56883, AtlasScreen.BACKGROUND_LOC, this.xLeft, this.yTop, 400, this.imageHeight);
        graphics.method_51439(this.field_22793, this.field_22785, this.xLeft + 10, this.yTop + 10, -12566464, false);
        int y = this.yTop + 25;
        y = this.drawLine(graphics, LABEL_NAME, this.spriteName.text(), y);
        y = this.drawLine(graphics, LABEL_POSITION, this.spritePosText, y);
        y = this.drawLine(graphics, LABEL_SIZE, this.spriteSizeText, y);
        y = this.drawLine(graphics, LABEL_SOURCEPACK, this.primarySourceName.text(), y);
        y = this.drawLine(graphics, LABEL_READERPACK, this.sourceInfo.sourcePack, y);
        y = this.drawLine(graphics, LABEL_READERTYPE, this.sourceInfo.sourceType, y);
        if (this.mipped) {
            y = this.drawLine(graphics, LABEL_MAX_MIP_LEVEL, this.maxMipLevel, y);
        }
        y = this.drawLine(graphics, LABEL_ANIMATED, this.animatedText, y);
        if (this.animated) {
            y = this.drawLine(graphics, LABEL_FRAMECOUNT, this.framesText, y);
            y = this.drawLine(graphics, LABEL_INTERPOLATED, this.interpText, y);
            y = this.drawLine(graphics, LABEL_FRAMETIME, this.frameTimeText, y);
        }
        if (this.guiSprite) {
            y = this.drawLine(graphics, LABEL_GUI_SPRITE_TYPE, this.guiSpriteTypeText, y);
            if (this.guiSpriteSizeText != null) {
                y = this.drawLine(graphics, LABEL_GUI_SPRITE_SIZE, this.guiSpriteSizeText, y);
            }
            if (this.guiSpriteNinesliceBorderText != null) {
                y = this.drawLine(graphics, LABEL_GUI_SPRITE_NINESLICE_BORDER, this.guiSpriteNinesliceBorderText, y);
            }
        }
        float scale = 128.0f / (float)Math.max(this.contents.method_45807(), this.contents.method_45815());
        graphics.method_52706(class_10799.field_56883, this.background.getSprite(), this.xLeft + 10, this.yTop + 25, (int)((float)this.contents.method_45807() * scale), (int)((float)this.contents.method_45815() * scale));
        GpuTextureView atlasTexView = this.atlas.comp_1051().atlasview$getMippedTextureView(this.currentMipLevel);
        ClientUtils.blitSpecial(graphics, class_10799.field_56883, class_11231.method_70900((GpuTextureView)atlasTexView), this.xLeft + 10, this.yTop + 25, this.xLeft + 10 + (int)((float)this.contents.method_45807() * scale), this.yTop + 25 + (int)((float)this.contents.method_45815() * scale), this.sprite.method_4594(), this.sprite.method_4577(), this.sprite.method_4593(), this.sprite.method_4575(), -1);
        if (this.btnExport.method_49606()) {
            this.setTooltipForNextFrame(graphics, MSG_EXPORT_DETAILS, mouseX, mouseY);
        } else if (this.btnExportMipped.field_22763 && this.btnExportMipped.method_49606()) {
            this.setTooltipForNextFrame(graphics, (class_2561)class_2561.method_43469((String)"msg.atlasviewer.export_mipped_atlas.detail", (Object[])new Object[]{this.currentMipLevel}), mouseX, mouseY);
        }
    }

    private int drawLine(class_332 graphics, class_2561 label, class_2561 value, int y) {
        graphics.method_51439(this.field_22793, label, this.xLeft + 148, y, -12566464, false);
        graphics.method_51439(this.field_22793, value, this.xLeft + this.valueX, y, -12566464, false);
        return y + 12;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        int lx = this.xLeft + 148;
        int lyPack = this.yTop + 25 + 48;
        int lyMip = this.yTop + 25 + 72;
        if (mouseX >= lx && mouseX < lx + this.field_22793.method_27525((class_5348)LABEL_READERPACK) && mouseY >= lyPack) {
            Objects.requireNonNull(this.field_22793);
            if (mouseY < lyPack + 9) {
                this.setTooltipForNextFrame(graphics, TOOLTIP_READERPACK, mouseX, mouseY);
                return;
            }
        }
        if (this.mipped && mouseX >= lx && mouseX < lx + this.field_22793.method_27525((class_5348)LABEL_MAX_MIP_LEVEL) && mouseY >= lyMip) {
            Objects.requireNonNull(this.field_22793);
            if (mouseY < lyMip + 9) {
                this.setTooltipForNextFrame(graphics, TOOLTIP_MAX_MIP_LEVEL, mouseX, mouseY);
                return;
            }
        }
        if (this.spriteName.capped() && this.isHoveringLine(mouseX, mouseY, 0, this.spriteName.text())) {
            this.setTooltipForNextFrame(graphics, this.spriteName.fullText(), mouseX, mouseY);
            return;
        }
        if (this.sourceInfo.sourcePackTooltip != null && this.isHoveringLine(mouseX, mouseY, 4, this.sourceInfo.sourcePack)) {
            if (this.sourceInfo.hasSourcePack) {
                this.setFixedTooltipForNextFrame(graphics, 4, this.sourceInfo.sourcePackTooltip);
                return;
            }
            this.setTooltipForNextFrame(graphics, this.sourceInfo.sourcePackTooltip, mouseX, mouseY);
            return;
        }
        if (this.sourceInfo.sourceTypeTooltip != null && this.isHoveringLine(mouseX, mouseY, 5, this.sourceInfo.sourceType)) {
            List<class_5481> lines = this.sourceInfo.sourceTypeTooltip;
            if (this.sourceInfo.hasConcreteSourceType && !this.minecraft().method_74187()) {
                lines = Objects.requireNonNull(this.sourceInfo.sourceTypeTooltipNoFullType);
            }
            graphics.method_51447(this.field_22793, lines, mouseX, mouseY);
            return;
        }
        if ((this.sourceNames.size() > 1 || this.primarySourceName.capped()) && this.isHoveringLine(mouseX, mouseY, 3, this.primarySourceName.text())) {
            this.setFixedTooltipForNextFrame(graphics, 3, this.sourceNameTooltip.entries, this.sourceNameTooltip.maxLen);
            return;
        }
        if (!this.mipped) return;
        if (!this.isHoveringLine(mouseX, mouseY, 6, this.maxMipLevel)) return;
        this.setTooltipForNextFrame(graphics, this.maxMipLevelTooltip, mouseX, mouseY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isHoveringLine(int mouseX, int mouseY, int lineIdx, class_2561 text) {
        int yTextTop = this.yTop + 25 + 12 * lineIdx;
        int xTextRight = this.xLeft + this.valueX + this.field_22793.method_27525((class_5348)text);
        if (mouseX < this.xLeft + this.valueX) return false;
        if (mouseX > xTextRight) return false;
        if (mouseY < yTextTop) return false;
        Objects.requireNonNull(this.field_22793);
        if (mouseY > yTextTop + 9) return false;
        return true;
    }

    private void setFixedTooltipForNextFrame(class_332 graphics, int lineIdx, class_2561 text) {
        List<class_5684> tooltip = List.of(class_5684.method_32662((class_5481)text.method_30937()));
        this.setFixedTooltipForNextFrame(graphics, lineIdx, tooltip, this.field_22793.method_27525((class_5348)text));
    }

    private void setFixedTooltipForNextFrame(class_332 graphics, int lineIdx, List<class_5684> components, int maxLen) {
        int x = Math.min(this.xLeft + this.valueX, this.field_22789 - maxLen - 5);
        int y = this.yTop + 25 + 12 * lineIdx;
        graphics.method_71273(this.field_22793, components, x, y, PACK_LIST_POSITIONER, null, true);
    }

    private List<String> collectSourcePackNames() {
        String capturedPackId;
        class_2960 name = this.contents.method_45816();
        class_2960 loc = Objects.requireNonNullElseGet(this.contents.atlasviewer$getOriginalPath(), () -> class_2960.method_60655((String)name.method_12836(), (String)("textures/" + name.method_12832() + ".png")));
        List resources = class_310.method_1551().method_1478().method_14489(loc);
        List sources = resources.stream().map(class_3298::method_45304).map(class_3262::method_14409).collect(Collectors.toCollection(ArrayList::new));
        if (sources.isEmpty() && (capturedPackId = this.contents.atlasviewer$getTextureSourcePack()) != null) {
            sources.add(capturedPackId);
        }
        Collections.reverse(sources);
        return sources;
    }

    private static class_8690 getGuiScaling(class_1058 sprite) {
        return sprite.method_45851().method_73021(class_8689.field_45647).orElse(class_8689.field_45645).comp_1636();
    }

    private SourcePackList makeTooltipList() {
        if (this.sourceNames.isEmpty()) {
            return new SourcePackList(List.of(), 0);
        }
        List<class_2561> lines = this.sourceNames.stream().map(class_2561::method_43470).map(class_2561.class::cast).toList();
        int maxWidth = lines.stream().mapToInt(arg_0 -> ((class_327)this.field_22793).method_27525(arg_0)).max().orElseThrow();
        TooltipSeparator seperator = new TooltipSeparator(maxWidth, -1, false);
        MutableBoolean first = new MutableBoolean(true);
        List components = lines.stream().flatMap(line -> {
            List lineComponents = this.field_22793.method_1728((class_5348)line, maxWidth).stream().map(class_5684::method_32662).collect(Collectors.toCollection(ArrayList::new));
            if (first.booleanValue() && lineComponents.size() == 1) {
                lineComponents.add(new TooltipSeparator(maxWidth, -1, true));
            } else {
                lineComponents.add(seperator);
            }
            first.setFalse();
            return lineComponents.stream();
        }).collect(Collectors.toCollection(ArrayList::new));
        components.removeLast();
        return new SourcePackList(components, maxWidth);
    }

    private SpriteSourceInfo makeSourceInfo() {
        List<Object> sourceTypeTooltip;
        class_2561 sourceType;
        class_2561 sourcePackTooltip;
        class_2561 sourcePack;
        int maxValueLen = 390 - this.valueX;
        boolean hasSourcePack = false;
        SourceAwareness awareness = this.contents.atlasviewer$getSourceAwareness();
        if (awareness == SourceAwareness.SOURCE_KNOWN) {
            String packId = this.contents.atlasviewer$getSpriteSourceSourcePack();
            if (packId != null && !packId.isEmpty()) {
                TextLine packIdPair = TextLine.of(packId, this.field_22793, maxValueLen);
                sourcePack = packIdPair.text();
                sourcePackTooltip = !sourcePack.equals((Object)packIdPair.fullText()) ? packIdPair.fullText() : null;
                hasSourcePack = true;
            } else {
                sourcePack = VALUE_UNKNOWN_PACK;
                sourcePackTooltip = null;
            }
        } else {
            sourcePack = awareness.getDescription();
            sourcePackTooltip = awareness.getTooltip();
        }
        List<class_5481> sourceTypeTooltipNoFullType = null;
        boolean hasConcreteSourceType = false;
        class_7948 source = this.contents.atlasviewer$getSpriteSource();
        if (source != null) {
            Class sourceTypeClazz = source.getClass();
            String typeDesc = SpriteSourceManager.getSpecialDescription(sourceTypeClazz);
            if (typeDesc != null) {
                TextLine typeNamePair = TextLine.of(typeDesc, this.field_22793, maxValueLen);
                sourceType = typeNamePair.text();
                sourceTypeTooltip = !sourceType.equals((Object)typeNamePair.fullText()) ? List.of(typeNamePair.fullText().method_30937()) : null;
            } else {
                String typeName = Services.PLATFORM.getSpriteSourceName(source);
                String shortTypeName = typeName.substring(typeName.lastIndexOf(46) + 1);
                sourceType = TextLine.of(shortTypeName, this.field_22793, maxValueLen).text();
                hasConcreteSourceType = true;
                List<class_3545<class_2561, class_2561>> tooltipLines = SpriteSourceManager.buildSourceTooltip(source, typeName);
                sourceTypeTooltip = SpriteInfoScreen.formatTooltip(tooltipLines);
                tooltipLines.getLast().method_34965((Object)FULL_TYPE_PLACEHOLDER);
                sourceTypeTooltipNoFullType = SpriteInfoScreen.formatTooltip(tooltipLines);
            }
        } else {
            sourceType = awareness.getDescription();
            sourceTypeTooltip = List.of(awareness.getTooltip().method_30937());
        }
        return new SpriteSourceInfo(sourcePack, sourcePackTooltip, hasSourcePack, sourceType, sourceTypeTooltip, sourceTypeTooltipNoFullType, hasConcreteSourceType);
    }

    private static List<class_5481> formatTooltip(List<class_3545<class_2561, class_2561>> tooltipLines) {
        return tooltipLines.stream().peek(pair -> {
            if (pair.method_15442() != null) {
                pair.method_34964((Object)((class_2561)pair.method_15442()).method_27661().method_27692(class_124.field_1056));
            }
        }).map(pair -> {
            class_5250 line = class_2561.method_43473();
            if (pair.method_15442() != null) {
                line = line.method_10852((class_2561)pair.method_15442()).method_27693(": ");
            }
            return line.method_10852((class_2561)pair.method_15441());
        }).map(class_2561::method_30937).toList();
    }

    private class_2561 calculateMaxMipLevel() {
        int lowestOne = Math.min(Integer.lowestOneBit(this.contents.method_45807()), Integer.lowestOneBit(this.contents.method_45815()));
        int maxLevel = Math.min(class_3532.method_15351((int)lowestOne), 4);
        return switch (maxLevel) {
            case 0 -> {
                this.maxMipLevelTooltip = TOOLTIP_MIPMAP_DISABLED;
                yield class_2561.method_43470((String)"0").method_27694(s -> s.method_36139(0xD00000));
            }
            case 4 -> {
                this.maxMipLevelTooltip = TOOLTIP_MIPMAP_FULL;
                yield class_2561.method_43470((String)"4").method_27694(s -> s.method_36139(53248));
            }
            default -> {
                this.maxMipLevelTooltip = class_2561.method_43469((String)"tooltip.atlasviewer.sprite.mipmap_limited", (Object[])new Object[]{maxLevel});
                yield class_2561.method_43470((String)String.valueOf(maxLevel)).method_27694(s -> s.method_36139(0xCC6600));
            }
        };
    }

    private int getAnimationFrameTime() {
        if (this.animation == null) {
            return 0;
        }
        List frames = this.animation.atlasviewer$getFrames();
        int first = ((class_7764.class_5791)frames.getFirst()).comp_3446();
        for (class_7764.class_5791 frame : frames) {
            if (frame.comp_3446() == first) continue;
            return -1;
        }
        return first;
    }

    private void selectMipLevel(int level) {
        this.currentMipLevel = level;
        this.btnExportMipped.field_22763 = level > 0;
    }

    private void exportSprite(class_4185 btn) {
        this.exportSprite(0);
    }

    private void exportSpriteMipped(class_4185 btn) {
        this.exportSprite(this.currentMipLevel);
    }

    private void exportSprite(int mipLevel) {
        try {
            class_1011 image = this.contents.atlasviewer$getByMipLevel()[mipLevel];
            AtlasScreen.exportNativeImage(image, this.contents.method_45816(), "sprite", mipLevel, false, MSG_EXPORT_SUCCESS);
        }
        catch (IOException e) {
            AtlasViewer.LOGGER.error("Encountered an error while exporting sprite", (Throwable)e);
            Services.PLATFORM.pushScreenLayer(MessageScreen.error(List.of(MSG_EXPORT_ERROR, class_2561.method_43470((String)e.getMessage()))));
        }
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (event.method_74245() == 0 && (event.comp_4798() < (double)this.xLeft || event.comp_4799() < (double)this.yTop || event.comp_4798() > (double)(this.xLeft + 400) || event.comp_4799() > (double)(this.yTop + this.imageHeight))) {
            this.method_25419();
            return true;
        }
        return super.method_25402(event, doubleClick);
    }

    public void method_25419() {
        Services.PLATFORM.popScreenLayer();
    }

    private record Label(class_2561 text, Predicate<SpriteInfoScreen> active) {
        public Label(class_2561 text) {
            this(text, screen -> true);
        }
    }

    private record SourcePackList(List<class_5684> entries, int maxLen) {
    }

    private record SpriteSourceInfo(class_2561 sourcePack, @Nullable class_2561 sourcePackTooltip, boolean hasSourcePack, class_2561 sourceType, @Nullable List<class_5481> sourceTypeTooltip, @Nullable List<class_5481> sourceTypeTooltipNoFullType, boolean hasConcreteSourceType) {
    }
}

