/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3545;
import net.minecraft.class_7764;
import net.minecraft.class_7948;
import net.minecraft.class_8684;
import org.jetbrains.annotations.Nullable;
import xfacthd.atlasviewer.client.AVClient;
import xfacthd.atlasviewer.client.api.ISpriteSourcePackAwareSpriteSupplier;
import xfacthd.atlasviewer.client.api.SourceAwareness;
import xfacthd.atlasviewer.client.api.SourceTooltipAppender;
import xfacthd.atlasviewer.client.mixin.AccessorSpriteSources;
import xfacthd.atlasviewer.client.util.WrappedSpriteSource;
import xfacthd.atlasviewer.client.util.WrappedSpriteSupplier;
import xfacthd.atlasviewer.platform.Services;

public final class SpriteSourceManager {
    private static final class_2561 LABEL_FULL_TYPE = class_2561.method_43471((String)"label.atlasviewer.source_tooltip.full_type");
    private static final class_2561 LABEL_REG_NAME = class_2561.method_43471((String)"label.atlasviewer.source_tooltip.reg_name");
    private static final class_2561 VALUE_UNREGISTERED = class_2561.method_43471((String)"value.atlasviewer.source_tooltip.unregistered").method_27694(s -> s.method_36139(0xD00000));
    private static final Map<Class<? extends class_7948.class_7950>, Function<class_7948.class_7950, class_3298>> PRIMARY_RESOURCE_GETTERS = new IdentityHashMap<Class<? extends class_7948.class_7950>, Function<class_7948.class_7950, class_3298>>();
    private static final Map<Class<? extends class_7948>, Function<class_7948, String>> SOURCE_STRINGIFIERS = new IdentityHashMap<Class<? extends class_7948>, Function<class_7948, String>>();
    private static final Map<Class<?>, String> SPECIAL_SOURCE_DESCRIPTIONS = new IdentityHashMap();
    private static final Map<Class<? extends class_7948>, SourceTooltipAppender<class_7948>> SOURCE_TOOLTIP_APPENDERS = new IdentityHashMap<Class<? extends class_7948>, SourceTooltipAppender<class_7948>>();
    private static boolean locked = true;

    public static <T extends class_7948.class_7950> void registerPrimaryResourceGetter(Class<T> supplierType, Function<T, class_3298> resourceGetter) {
        Preconditions.checkState((!locked ? 1 : 0) != 0, (Object)"Registration is locked");
        if (PRIMARY_RESOURCE_GETTERS.put(supplierType, resourceGetter) != null) {
            throw new IllegalStateException("Supplier type '%s' had a previous mapping".formatted(supplierType));
        }
    }

    public static <T extends class_7948> void registerSourceStringifier(Class<T> sourceType, Function<T, String> stringifier) {
        Preconditions.checkState((!locked ? 1 : 0) != 0, (Object)"Registration is locked");
        if (SOURCE_STRINGIFIERS.put(sourceType, stringifier) != null) {
            throw new IllegalStateException("Source type '%s' had a previous mapping".formatted(sourceType));
        }
    }

    public static <T extends class_7948> void registerSimpleSourceStringifier(Class<T> sourceType, Function<T, String> stringifier) {
        SpriteSourceManager.registerSourceStringifier(sourceType, src -> "'%s' ('%s')".formatted(Services.PLATFORM.getSpriteSourceSimpleName((class_7948)src), stringifier.apply(src)));
    }

    public static <T extends class_7948> void registerSpecialSourceDescription(Class<T> sourceType, String description) {
        Preconditions.checkState((!locked ? 1 : 0) != 0, (Object)"Registration is locked");
        if (SPECIAL_SOURCE_DESCRIPTIONS.put(sourceType, description) != null) {
            throw new IllegalStateException("Source type '%s' had a previous mapping".formatted(sourceType));
        }
    }

    public static <T extends class_7948> void registerSourceTooltipAppender(Class<T> sourceType, SourceTooltipAppender<T> appender) {
        Preconditions.checkState((!locked ? 1 : 0) != 0, (Object)"Registration is locked");
        if (SOURCE_TOOLTIP_APPENDERS.put(sourceType, appender) != null) {
            throw new IllegalStateException("Source type '%s' had a previous mapping".formatted(sourceType));
        }
    }

    public static void copySpriteSupplierMetaToSpriteContents(Function<class_8684, class_7764> function, @Nullable class_7764 contents) {
        if (contents == null) {
            return;
        }
        if (!(function instanceof class_7948.class_7950)) {
            contents.atlasviewer$setSpriteSourceSourcePack(null, null, SourceAwareness.SPRITESUPPLIER_UNSUPPORTED, null, null);
            return;
        }
        class_7948.class_7950 supplier = (class_7948.class_7950)function;
        class_7948.class_7950 unwrappedSupplier = WrappedSpriteSupplier.resolve(supplier);
        Function<class_7948.class_7950, class_3298> resourceGetter = PRIMARY_RESOURCE_GETTERS.get(unwrappedSupplier.getClass());
        if (resourceGetter != null) {
            contents.atlasviewer$captureMetaFromSpriteSupplier(supplier, resourceGetter.apply(unwrappedSupplier));
        } else if (!(unwrappedSupplier instanceof ISpriteSourcePackAwareSpriteSupplier)) {
            contents.atlasviewer$setSpriteSourceSourcePack(null, null, SourceAwareness.SPRITESUPPLIER_UNSUPPORTED, null, null);
        }
    }

    public static String stringifySpriteSource(class_7948 source) {
        source = WrappedSpriteSource.resolve(source);
        return SOURCE_STRINGIFIERS.getOrDefault(source.getClass(), class_7948::toString).apply(source);
    }

    @Nullable
    public static String getSpecialDescription(Class<?> sourceType) {
        return SPECIAL_SOURCE_DESCRIPTIONS.get(sourceType);
    }

    public static List<class_3545<class_2561, class_2561>> buildSourceTooltip(class_7948 source, String typeName) {
        ArrayList<class_3545<class_2561, class_2561>> lines = new ArrayList<class_3545<class_2561, class_2561>>();
        source = WrappedSpriteSource.resolve(source);
        class_2960 regLoc = (class_2960)AccessorSpriteSources.atlasviewer$getTypes().atlasviewer$getKey((Object)source.method_67288());
        class_2561 regName = regLoc != null ? class_2561.method_43470((String)regLoc.toString()) : VALUE_UNREGISTERED;
        lines.add(new class_3545((Object)LABEL_REG_NAME, (Object)regName));
        SourceTooltipAppender<class_7948> appender = SOURCE_TOOLTIP_APPENDERS.get(source.getClass());
        if (appender != null) {
            appender.accept(source, (title, content) -> lines.add(new class_3545((Object)title, (Object)content)));
        }
        lines.add(new class_3545((Object)LABEL_FULL_TYPE, (Object)class_2561.method_43470((String)typeName)));
        return lines;
    }

    public static void registerDetails() {
        locked = false;
        AVClient.registerBuiltInSpriteSourceDetails();
        Services.PLATFORM.registerPlatformSpecificBuiltInSpriteSourceDetails();
        Services.PLATFORM.fireSpriteSourceDetailsEvent();
        locked = true;
    }

    private SpriteSourceManager() {
    }
}

