/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.mixin;

import com.leclowndu93150.particular.CommonClass;
import com.leclowndu93150.particular.ParticularConfig;
import com.leclowndu93150.particular.mixin.AccessorChestBlockEntity;
import com.leclowndu93150.particular.mixin.InvokerViewerCountManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChestBlockEntity.class})
public abstract class InjectChestBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity {
    @Unique
    private int ticksUntilNextSwitch = 20;
    @Unique
    private boolean isOpen = false;
    @Unique
    private static final int minClosedTime = 160;
    @Unique
    private static final int maxClosedTime = 480;
    @Unique
    private static final int minOpenTime = 40;
    @Unique
    private static final int maxOpenTime = 60;

    public InjectChestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Unique
    private static boolean getSoulSand(Level world, BlockPos pos, BlockState state) {
        if (world.getBlockState(pos = pos.below()).getBlock() == Blocks.SOUL_SAND) {
            return true;
        }
        if (state.getValue((Property)BlockStateProperties.CHEST_TYPE) == ChestType.RIGHT) {
            BlockPos pos2 = pos.offset(((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getCounterClockWise(Direction.Axis.Y).getUnitVec3i());
            return world.getBlockState(pos2).getBlock() == Blocks.SOUL_SAND;
        }
        return false;
    }

    @Inject(method={"lidAnimateTick"}, at={@At(value="TAIL")})
    private static void randomlyOpen(Level world, BlockPos pos, BlockState state, ChestBlockEntity blockEntity, CallbackInfo ci) {
        if (!ParticularConfig.soulSandBubbles()) {
            return;
        }
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() || state.getValue((Property)BlockStateProperties.CHEST_TYPE) == ChestType.LEFT || !InjectChestBlockEntity.getSoulSand(world, pos, state)) {
            return;
        }
        InjectChestBlockEntity injected = (InjectChestBlockEntity)blockEntity;
        if (--injected.ticksUntilNextSwitch <= 0) {
            ContainerOpenersCounter manager = ((AccessorChestBlockEntity)blockEntity).getStateManager();
            if (injected.isOpen) {
                injected.isOpen = false;
                injected.ticksUntilNextSwitch = world.random.nextIntBetweenInclusive(160, 480);
                ((AccessorChestBlockEntity)blockEntity).getLidAnimator().shouldBeOpen(false);
                ((InvokerViewerCountManager)manager).invokeOnContainerClose(world, pos, blockEntity.getBlockState());
            } else {
                injected.isOpen = true;
                injected.ticksUntilNextSwitch = world.random.nextIntBetweenInclusive(40, 60);
                ((AccessorChestBlockEntity)blockEntity).getLidAnimator().shouldBeOpen(true);
                ((InvokerViewerCountManager)manager).invokeOnContainerOpen(world, pos, blockEntity.getBlockState());
                world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.AMBIENT, 1.0f, 1.0f, true);
            }
        }
        if (injected.isOpen && injected.ticksUntilNextSwitch > 10 && injected.ticksUntilNextSwitch % 2 == 0) {
            if (state.getValue((Property)BlockStateProperties.CHEST_TYPE) == ChestType.SINGLE) {
                CommonClass.spawnBubble((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, world, pos);
            } else {
                CommonClass.spawnDoubleBubbles((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, world, pos, state);
            }
        }
    }
}

