/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.mixin;

import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.ParticularConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WaterFluid.class})
public class InjectWaterFluid {
    @Inject(method={"animateTick"}, at={@At(value="TAIL")})
    private void waterParticles(Level world, BlockPos pos, FluidState state, RandomSource random, CallbackInfo ci) {
        if (!ParticularConfig.waterfallSpray()) {
            return;
        }
        if (!state.isSource() && world.getFluidState(pos.below()).is(FluidTags.WATER)) {
            for (int i = 0; i < 2; ++i) {
                double z;
                double y;
                double x;
                if (((Boolean)state.getValue((Property)BlockStateProperties.FALLING)).booleanValue()) {
                    x = pos.getX();
                    y = (double)pos.getY() + random.nextDouble();
                    z = pos.getZ();
                    if (random.nextBoolean()) {
                        x += random.nextDouble();
                        z += (double)random.nextIntBetweenInclusive(0, 1);
                    } else {
                        x += (double)random.nextIntBetweenInclusive(0, 1);
                        z += random.nextDouble();
                    }
                    world.addParticle((ParticleOptions)Particles.WATERFALL_SPRAY(), x, y, z, 0.0, 0.0, 0.0);
                    continue;
                }
                x = (double)pos.getX() + random.nextDouble();
                y = (double)pos.getY() + random.nextDouble() * (double)state.getOwnHeight();
                z = (double)pos.getZ() + random.nextDouble();
                Vec3 vel = state.getFlow((BlockGetter)world, pos).scale(0.075);
                world.addParticle((ParticleOptions)Particles.WATERFALL_SPRAY(), x, y, z, vel.x, 0.0, vel.z);
            }
        }
    }
}

