/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles;

import java.awt.Color;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FluidState;

public class WaterfallSprayParticle
extends WaterDropParticle {
    protected WaterfallSprayParticle(ClientLevel clientWorld, double d, double e, double f, double g, double h, double i, TextureAtlasSprite textureAtlasSprite) {
        super(clientWorld, d, e, f, textureAtlasSprite);
        this.xd += g;
        this.yd *= 0.75;
        this.zd += i;
        Color color = new Color(BiomeColors.getAverageWaterColor((BlockAndTintGetter)clientWorld, (BlockPos)BlockPos.containing((double)this.x, (double)this.y, (double)this.z)));
        this.rCol = (float)color.getRed() / 255.0f;
        this.gCol = (float)color.getGreen() / 255.0f;
        this.bCol = (float)color.getBlue() / 255.0f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        } else {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)0.98f;
            this.yd *= (double)0.98f;
            this.zd *= (double)0.98f;
            if (this.onGround) {
                if (Math.random() < 0.5) {
                    this.remove();
                }
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
            BlockPos blockPos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
            double d = this.level.getBlockState(blockPos).getCollisionShape((BlockGetter)this.level, blockPos).max(Direction.Axis.Y, this.x - (double)blockPos.getX(), this.z - (double)blockPos.getZ());
            FluidState fluidState = this.level.getFluidState(blockPos);
            if (fluidState.isSource()) {
                d = Math.max(d, (double)fluidState.getHeight((BlockGetter)this.level, blockPos));
            }
            if (d > 0.0 && this.y < (double)blockPos.getY() + d) {
                this.remove();
            }
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i, RandomSource random) {
            WaterfallSprayParticle waterfallSprayParticle = new WaterfallSprayParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider.get(random));
            waterfallSprayParticle.setSpriteFromAge(this.spriteProvider);
            return waterfallSprayParticle;
        }
    }
}

