/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles.leaves;

import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.ParticularConfig;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class LeafParticle
extends SingleQuadParticle {
    protected static final int fadeInDuration = 10;
    protected static final int rampUpDuration = 20;
    protected static final int fadeOutDuration = 100;
    protected float rotateFactor;
    protected float gravityFactor = 0.075f;
    protected final boolean flippedSprite;
    protected final int flippedDirection;
    protected boolean expiring = false;
    protected final SpriteSet provider;

    protected LeafParticle(ClientLevel world, double x, double y, double z, double r, double g, double b, SpriteSet provider) {
        super(world, x, y, z, provider.first());
        this.hasPhysics = true;
        this.gravity = 0.0f;
        this.lifetime = 200;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.alpha = 0.0f;
        this.rCol = (float)r;
        this.gCol = (float)g;
        this.bCol = (float)b;
        this.rotateFactor = 6.0f + (float)Math.random() * 3.0f;
        this.flippedSprite = this.random.nextBoolean();
        this.flippedDirection = this.random.nextBoolean() ? 1 : -1;
        this.quadSize = 0.21875f;
        this.provider = provider;
    }

    protected float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    protected float getAngle() {
        int time = this.age - 10;
        float speed = this.rotateFactor;
        float amplitude = this.clamp(time, 0.0f, 30.0f) / 30.0f;
        return (float)Math.sin((float)time / speed) * amplitude * 0.5f * (float)this.flippedDirection;
    }

    public void tick() {
        super.tick();
        if (this.age <= 10) {
            this.yd = 0.0;
        } else if (!this.expiring && (this.onGround || this.yd == 0.0)) {
            this.expiring = true;
            this.age = this.lifetime - 100;
            this.y += 0.01;
            if (((Boolean)ParticularConfig.COMMON.fallingLeavesLayFlatOnGround.get()).booleanValue()) {
                this.roll = (Boolean)ParticularConfig.COMMON.fallingLeavesLayFlatRightAngles.get() != false ? (float)((double)this.random.nextInt(4) / 2.0 * Math.PI) : (float)(Math.random() * Math.PI * 2.0);
            }
        }
        this.oRoll = this.roll;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        FluidState fluidState = this.level.getFluidState(pos);
        if (fluidState.is(FluidTags.WATER)) {
            if (this.gravity > 0.0f) {
                this.y = (float)pos.getY() + fluidState.getHeight((BlockGetter)this.level, pos);
                if (((Boolean)ParticularConfig.COMMON.fallingLeavesSpawnRipples.get()).booleanValue()) {
                    this.level.addParticle((ParticleOptions)Particles.WATER_RIPPLE(), this.x, this.y, this.z, 0.0, 0.0, 0.0);
                }
            }
            this.yd = 0.0;
            this.gravity = 0.0f;
        } else if (this.age >= 10) {
            this.gravity = this.gravityFactor;
            if (!this.onGround) {
                this.roll = this.getAngle();
            }
        }
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public void extract(QuadParticleRenderState renderState, Camera camera, float partialTick) {
        float ageDelta = Mth.lerpInt((float)partialTick, (int)this.age, (int)(this.age + 1));
        this.alpha = this.age <= 10 ? ageDelta / 10.0f : (this.age > this.lifetime - 100 ? Math.max(0.0f, ((float)this.lifetime - ageDelta) / 100.0f) : 1.0f);
        Vec3 vec3 = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - vec3.x());
        float y = (float)(Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - vec3.y());
        float z = (float)(Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - vec3.z());
        float u0 = this.getU0();
        float u1 = this.getU1();
        if (this.flippedSprite) {
            float temp = u0;
            u0 = u1;
            u1 = temp;
        }
        if (this.expiring && ((Boolean)ParticularConfig.COMMON.fallingLeavesLayFlatOnGround.get()).booleanValue()) {
            y += 0.01f;
            Quaternionf rotationTop = new Quaternionf();
            rotationTop.rotateX(1.5707964f);
            rotationTop.rotateZ(Mth.lerp((float)partialTick, (float)this.oRoll, (float)this.roll));
            Quaternionf rotationBottom = new Quaternionf();
            rotationBottom.rotateX(-1.5707964f);
            rotationBottom.rotateZ(Mth.lerp((float)partialTick, (float)this.oRoll, (float)this.roll));
            renderState.add(this.getLayer(), x, y, z, rotationTop.x, rotationTop.y, rotationTop.z, rotationTop.w, this.getQuadSize(partialTick), u0, u1, this.getV0(), this.getV1(), ARGB.colorFromFloat((float)this.alpha, (float)this.rCol, (float)this.gCol, (float)this.bCol), this.getLightColor(partialTick));
            renderState.add(this.getLayer(), x, y, z, rotationBottom.x, rotationBottom.y, rotationBottom.z, rotationBottom.w, this.getQuadSize(partialTick), u0, u1, this.getV0(), this.getV1(), ARGB.colorFromFloat((float)this.alpha, (float)this.rCol, (float)this.gCol, (float)this.bCol), this.getLightColor(partialTick));
        } else {
            Quaternionf rotation = new Quaternionf((Quaternionfc)camera.rotation());
            if (this.roll != 0.0f) {
                rotation.rotateZ(Mth.lerp((float)partialTick, (float)this.oRoll, (float)this.roll));
            }
            renderState.add(this.getLayer(), x, y, z, rotation.x, rotation.y, rotation.z, rotation.w, this.getQuadSize(partialTick), u0, u1, this.getV0(), this.getV1(), ARGB.colorFromFloat((float)this.alpha, (float)this.rCol, (float)this.gCol, (float)this.bCol), this.getLightColor(partialTick));
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public Factory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velX, double velY, double velZ, RandomSource random) {
            return new LeafParticle(world, x, y, z, velX, velY, velZ, this.provider);
        }
    }
}

