/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles.splashes;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleGroup;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.state.ParticleGroupRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class WaterSplashParticle
extends Particle {
    public static final ParticleRenderType WATER_SPLASH_TYPE = new ParticleRenderType("particular:water_splash");
    protected final SpriteSet provider;
    private final float width;
    private final float height;
    private final Color color;
    protected boolean colored = true;

    WaterSplashParticle(ClientLevel clientWorld, double x, double y, double z, float width, float height, SpriteSet provider) {
        super(clientWorld, x, y, z);
        this.gravity = 0.0f;
        this.lifetime = 18;
        this.width = width;
        this.height = height;
        this.provider = provider;
        this.color = new Color(BiomeColors.getAverageWaterColor((BlockAndTintGetter)clientWorld, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z)));
    }

    public ParticleRenderType getGroup() {
        return WATER_SPLASH_TYPE;
    }

    public void tick() {
        super.tick();
        if (!this.level.getFluidState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).is(FluidTags.WATER)) {
            this.remove();
        }
    }

    private static class WaterSplashGroupRenderState
    implements ParticleGroupRenderState {
        private final List<WaterSplashRenderData> renderDataList;

        public WaterSplashGroupRenderState(List<WaterSplashRenderData> renderDataList) {
            this.renderDataList = renderDataList;
        }

        public void submit(SubmitNodeCollector collector, CameraRenderState cameraState) {
            if (this.renderDataList.isEmpty()) {
                return;
            }
            PoseStack poseStack = new PoseStack();
            collector.submitCustomGeometry(poseStack, RenderType.entityTranslucent((ResourceLocation)TextureAtlas.LOCATION_PARTICLES), (pose, consumer) -> {
                for (WaterSplashRenderData data : this.renderDataList) {
                    this.renderSide(consumer, data.corners, 0, 1, data.baseY, data.height, data.u0, data.u1, data.v0, data.v1, data.color, data.light);
                    this.renderSide(consumer, data.corners, 1, 2, data.baseY, data.height, data.u0, data.u1, data.v0, data.v1, data.color, data.light);
                    this.renderSide(consumer, data.corners, 2, 3, data.baseY, data.height, data.u0, data.u1, data.v0, data.v1, data.color, data.light);
                    this.renderSide(consumer, data.corners, 3, 0, data.baseY, data.height, data.u0, data.u1, data.v0, data.v1, data.color, data.light);
                }
            });
        }

        private void renderSide(VertexConsumer consumer, Vector3f[] corners, int a, int b, float baseY, float height, float u0, float u1, float v0, float v1, int color, int light) {
            Vector3f cornerA = corners[a];
            Vector3f cornerB = corners[b];
            float bottomAX = cornerA.x;
            float bottomAZ = cornerA.z;
            float bottomBX = cornerB.x;
            float bottomBZ = cornerB.z;
            float topAX = cornerA.x;
            float topAZ = cornerA.z;
            float topBX = cornerB.x;
            float topBZ = cornerB.z;
            float dx = bottomBX - bottomAX;
            float dz = bottomBZ - bottomAZ;
            float normalX = -dz;
            float normalY = 0.0f;
            float normalZ = dx;
            float length = (float)Math.sqrt(normalX * normalX + normalZ * normalZ);
            if (length > 0.0f) {
                normalX /= length;
                normalZ /= length;
            }
            int noOverlay = OverlayTexture.NO_OVERLAY;
            consumer.addVertex(bottomAX, baseY, bottomAZ).setUv(u0, v1).setColor(color).setOverlay(noOverlay).setLight(light).setNormal(normalX, normalY, normalZ);
            consumer.addVertex(bottomBX, baseY, bottomBZ).setUv(u1, v1).setColor(color).setOverlay(noOverlay).setLight(light).setNormal(normalX, normalY, normalZ);
            consumer.addVertex(topBX, baseY + height, topBZ).setUv(u1, v0).setColor(color).setOverlay(noOverlay).setLight(light).setNormal(normalX, normalY, normalZ);
            consumer.addVertex(topAX, baseY + height, topAZ).setUv(u0, v0).setColor(color).setOverlay(noOverlay).setLight(light).setNormal(normalX, normalY, normalZ);
            consumer.addVertex(bottomBX, baseY, bottomBZ).setUv(u0, v1).setColor(color).setOverlay(noOverlay).setLight(light).setNormal(-normalX, normalY, -normalZ);
            consumer.addVertex(bottomAX, baseY, bottomAZ).setUv(u1, v1).setColor(color).setOverlay(noOverlay).setLight(light).setNormal(-normalX, normalY, -normalZ);
            consumer.addVertex(topAX, baseY + height, topAZ).setUv(u1, v0).setColor(color).setOverlay(noOverlay).setLight(light).setNormal(-normalX, normalY, -normalZ);
            consumer.addVertex(topBX, baseY + height, topBZ).setUv(u0, v0).setColor(color).setOverlay(noOverlay).setLight(light).setNormal(-normalX, normalY, -normalZ);
        }
    }

    private record WaterSplashRenderData(Vector3f[] corners, float baseY, float height, float u0, float u1, float v0, float v1, int color, int light) {
    }

    public static class WaterSplashParticleGroup
    extends ParticleGroup<WaterSplashParticle> {
        public WaterSplashParticleGroup(ParticleEngine engine) {
            super(engine);
        }

        public ParticleGroupRenderState extractRenderState(Frustum frustum, Camera camera, float partialTick) {
            ArrayList<WaterSplashRenderData> renderDataList = new ArrayList<WaterSplashRenderData>();
            for (WaterSplashParticle particle : this.particles) {
                if (!particle.isAlive()) continue;
                TextureAtlasSprite sprite = particle.provider.get(particle.age, particle.lifetime);
                float uvWidth = sprite.getU1() - sprite.getU0();
                float unit = uvWidth / ((float)sprite.contents().width() / 2.0f);
                float u0 = sprite.getU0() + unit;
                float u1 = sprite.getU1() - unit;
                float v0 = sprite.getV0();
                float v1 = sprite.getV1();
                float rCol = particle.colored ? (float)particle.color.getRed() / 255.0f : 1.0f;
                float gCol = particle.colored ? (float)particle.color.getGreen() / 255.0f : 1.0f;
                float bCol = particle.colored ? (float)particle.color.getBlue() / 255.0f : 1.0f;
                Vec3 vec3 = camera.getPosition();
                float camX = (float)(Mth.lerp((double)partialTick, (double)particle.xo, (double)particle.x) - vec3.x());
                float camY = (float)(Mth.lerp((double)partialTick, (double)particle.yo, (double)particle.y) - vec3.y());
                float camZ = (float)(Mth.lerp((double)partialTick, (double)particle.zo, (double)particle.z) - vec3.z());
                float ageDelta = Mth.lerp((float)partialTick, (float)(particle.age - 1), (float)particle.age);
                float progress = ageDelta / (float)particle.lifetime;
                float scale = particle.width * (0.8f + 0.2f * progress);
                Vector3f[] corners = new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
                for (int i = 0; i < 4; ++i) {
                    corners[i].mul(scale);
                    corners[i].add(camX, camY, camZ);
                }
                int light = particle.getLightColor(partialTick);
                int argb = ARGB.colorFromFloat((float)1.0f, (float)rCol, (float)gCol, (float)bCol);
                renderDataList.add(new WaterSplashRenderData(corners, camY, particle.height, u0, u1, v0, v1, argb, light));
            }
            return new WaterSplashGroupRenderState(renderDataList);
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public Factory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double g, double h, double i, RandomSource random) {
            return new WaterSplashParticle(world, x, y, z, (float)g, (float)h, this.provider);
        }
    }
}

