/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles.splashes;

import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class WaterSplashRingParticle
extends SingleQuadParticle {
    protected final SpriteSet provider;
    private final float width;

    WaterSplashRingParticle(ClientLevel clientWorld, double x, double y, double z, float width, SpriteSet provider) {
        super(clientWorld, x, y, z, provider.first());
        this.gravity = 0.0f;
        this.lifetime = 18;
        this.width = width;
        this.provider = provider;
        this.setSpriteFromAge(provider);
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.provider);
        if (!this.level.getFluidState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).is(FluidTags.WATER)) {
            this.remove();
        }
    }

    public void extract(QuadParticleRenderState renderState, Camera camera, float partialTick) {
        Vec3 vec3 = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - vec3.x());
        float y = (float)(Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - vec3.y()) + 0.01f;
        float z = (float)(Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - vec3.z());
        float ageDelta = Mth.lerp((float)partialTick, (float)(this.age - 1), (float)this.age);
        float progress = ageDelta / (float)this.lifetime;
        float scale = this.width * (0.8f + 0.2f * progress);
        Quaternionf rotationTop = new Quaternionf().rotateX(1.5707964f);
        Quaternionf rotationBottom = new Quaternionf().rotateX(-1.5707964f);
        renderState.add(this.getLayer(), x, y, z, rotationTop.x, rotationTop.y, rotationTop.z, rotationTop.w, scale, this.getU0(), this.getU1(), this.getV0(), this.getV1(), ARGB.colorFromFloat((float)this.alpha, (float)this.rCol, (float)this.gCol, (float)this.bCol), this.getLightColor(partialTick));
        renderState.add(this.getLayer(), x, y, z, rotationBottom.x, rotationBottom.y, rotationBottom.z, rotationBottom.w, scale, this.getU0(), this.getU1(), this.getV0(), this.getV1(), ARGB.colorFromFloat((float)this.alpha, (float)this.rCol, (float)this.gCol, (float)this.bCol), this.getLightColor(partialTick));
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public Factory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double g, double h, double i, RandomSource random) {
            return new WaterSplashRingParticle(world, x, y, z, (float)g, this.provider);
        }
    }
}

