/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular;

import com.leclowndu93150.particular.Main;
import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.ParticularConfig;
import com.leclowndu93150.particular.compat.RegionsUnexplored;
import com.leclowndu93150.particular.compat.Traverse;
import com.leclowndu93150.particular.compat.WilderWild;
import com.leclowndu93150.particular.utils.CascadeData;
import com.leclowndu93150.particular.utils.LeafColorUtil;
import com.leclowndu93150.particular.utils.TextureCache;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ClientStuff {
    public static Map<Block, LeafData> leavesData = new HashMap<Block, LeafData>();

    public static Color extractLeafColor(Level world, BlockPos pos, Block block) {
        BlockState state = block.m_49966_();
        try {
            if (world.m_8055_(pos).m_60734_() == block) {
                state = world.m_8055_(pos);
            }
            double[] colorValues = LeafColorUtil.getBlockTextureColor(state, world, pos);
            return LeafColorUtil.getColorFromValues(colorValues);
        }
        catch (Exception e) {
            Main.LOGGER.error("Failed to extract leaf color", (Throwable)e);
            return new Color(BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos));
        }
    }

    public static void registerLeafData(Block block, LeafData leafData) {
        leavesData.put(block, leafData);
    }

    public static void registerLeafData(ResourceLocation id, LeafData leafData) {
        BuiltInRegistries.f_256975_.m_6612_(id).ifPresent(block -> leavesData.put((Block)block, leafData));
    }

    public static LeafData getLeafData(Block block) {
        return leavesData.getOrDefault(block, new LeafData((ParticleOptions)Particles.OAK_LEAF.get()));
    }

    private static void cleanupInvalidCascades(Level world) {
        if (!ParticularConfig.cascades()) {
            Main.cascades.clear();
            return;
        }
        long currentTime = world.m_46467_();
        Main.cascades.entrySet().removeIf(entry -> {
            BlockPos pos = (BlockPos)entry.getKey();
            CascadeData cascadeData = (CascadeData)entry.getValue();
            if (!world.m_46805_(pos)) {
                return true;
            }
            if (currentTime - cascadeData.createdTime > 100L) {
                return true;
            }
            FluidState currentState = world.m_6425_(pos);
            FluidState aboveState = world.m_6425_(pos.m_7494_());
            FluidState belowState = world.m_6425_(pos.m_7495_());
            boolean isValid = currentState.m_192917_((Fluid)Fluids.f_76193_) && aboveState.m_192917_((Fluid)Fluids.f_76192_) && belowState.m_192917_((Fluid)Fluids.f_76193_);
            return !isValid;
        });
    }

    public static class LeafData {
        private final ParticleOptions particle;
        private final BiFunction<Level, BlockPos, Color> colorBiFunc;

        public LeafData(ParticleOptions particle, BiFunction<Level, BlockPos, Color> colorBiFunc) {
            this.particle = particle;
            this.colorBiFunc = colorBiFunc;
        }

        public LeafData(ParticleOptions particle, Color color) {
            this(particle, (Level world, BlockPos pos) -> color);
        }

        public LeafData(ParticleOptions particle) {
            this(particle, (Level world, BlockPos pos) -> {
                Block block = world.m_8055_(pos).m_60734_();
                return ClientStuff.extractLeafColor(world, pos, block);
            });
        }

        public ParticleOptions getParticle() {
            return this.particle;
        }

        public Color getColor(Level world, BlockPos pos) {
            return this.colorBiFunc.apply(world, pos);
        }
    }

    @Mod.EventBusSubscriber(modid="particular", value={Dist.CLIENT})
    public static class ClientEvents {
        private static int cascadeCleanupTicks = 0;

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            leavesData.put(Blocks.f_50050_, new LeafData((ParticleOptions)Particles.OAK_LEAF.get()));
            leavesData.put(Blocks.f_50052_, new LeafData((ParticleOptions)Particles.BIRCH_LEAF.get(), new Color(FoliageColor.m_46112_())));
            leavesData.put(Blocks.f_50051_, new LeafData((ParticleOptions)Particles.SPRUCE_LEAF.get(), new Color(FoliageColor.m_46106_())));
            leavesData.put(Blocks.f_50053_, new LeafData((ParticleOptions)Particles.JUNGLE_LEAF.get()));
            leavesData.put(Blocks.f_50054_, new LeafData((ParticleOptions)Particles.ACACIA_LEAF.get()));
            leavesData.put(Blocks.f_50055_, new LeafData((ParticleOptions)Particles.DARK_OAK_LEAF.get()));
            leavesData.put(Blocks.f_152470_, new LeafData((ParticleOptions)Particles.AZALEA_LEAF.get(), Color.white));
            leavesData.put(Blocks.f_152471_, new LeafData((ParticleOptions)Particles.AZALEA_LEAF.get(), Color.white));
            leavesData.put(Blocks.f_220838_, new LeafData((ParticleOptions)Particles.MANGROVE_LEAF.get()));
            leavesData.put(Blocks.f_271115_, new LeafData(null));
            if (ModList.get().isLoaded("traverse")) {
                Traverse.addLeaves();
            }
            if (ModList.get().isLoaded("regions_unexplored")) {
                RegionsUnexplored.addLeaves();
            }
            if (ModList.get().isLoaded("wilderwild")) {
                WilderWild.addLeaves();
            }
            event.enqueueWork(() -> {
                for (Block block : ForgeRegistries.BLOCKS) {
                    boolean isLeafBlock;
                    ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
                    if (leavesData.containsKey(block) || !(isLeafBlock = block instanceof LeavesBlock || id.m_135815_().contains("leaves") || id.m_135815_().contains("leaf"))) continue;
                    ParticleOptions particle = (ParticleOptions)Particles.OAK_LEAF.get();
                    if (id.m_135815_().contains("spruce") || id.m_135815_().contains("pine") || id.m_135815_().contains("fir") || id.m_135815_().contains("conifer")) {
                        particle = (ParticleOptions)Particles.SPRUCE_LEAF.get();
                    } else if (id.m_135815_().contains("birch")) {
                        particle = (ParticleOptions)Particles.BIRCH_LEAF.get();
                    } else if (id.m_135815_().contains("jungle")) {
                        particle = (ParticleOptions)Particles.JUNGLE_LEAF.get();
                    } else if (id.m_135815_().contains("acacia")) {
                        particle = (ParticleOptions)Particles.ACACIA_LEAF.get();
                    } else if (id.m_135815_().contains("dark_oak")) {
                        particle = (ParticleOptions)Particles.DARK_OAK_LEAF.get();
                    } else if (id.m_135815_().contains("mangrove")) {
                        particle = (ParticleOptions)Particles.MANGROVE_LEAF.get();
                    }
                    LeafData leafData = new LeafData(particle);
                    leavesData.put(block, leafData);
                }
            });
        }

        @SubscribeEvent
        public static void onResourcesReloaded(TextureStitchEvent.Post event) {
            TextureCache.clear();
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null || event.phase != TickEvent.Phase.START) {
                return;
            }
            RandomSource random = world.f_46441_;
            if (world.m_46468_() == (long)((Integer)ParticularConfig.COMMON.fireflyStartTime.get()).intValue()) {
                List dailyRandomList = (List)ParticularConfig.COMMON.fireflyDailyRandom.get();
                Main.fireflyFrequency = ((Double)dailyRandomList.get(random.m_188503_(dailyRandomList.size()))).floatValue();
            }
            if (!ParticularConfig.waterSplash()) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            int renderDistance = (Integer)mc.f_91066_.m_231984_().m_231551_();
            BlockPos playerPos = mc.f_91074_.m_20183_();
            long currentTime = world.m_46467_();
            Main.cascades.entrySet().removeIf(arg_0 -> ClientEvents.lambda$onClientTick$1(playerPos, renderDistance, currentTime, (Level)world, random, mc, arg_0));
            if (++cascadeCleanupTicks >= 100) {
                cascadeCleanupTicks = 0;
                ClientStuff.cleanupInvalidCascades((Level)world);
            }
        }

        @SubscribeEvent
        public static void onRenderHUD(RenderGuiOverlayEvent.Post event) {
            if (FMLLoader.isProduction()) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null || mc.f_91073_ == null) {
                return;
            }
            GuiGraphics guiGraphics = event.getGuiGraphics();
            Font font = mc.f_91062_;
            String cascadeText = "Cascades: " + Main.cascades.size();
            int textWidth = font.m_92895_(cascadeText);
            int x = 10;
            int y = 10;
            Objects.requireNonNull(font);
            guiGraphics.m_280509_(x - 2, y - 2, x + textWidth + 2, y + 9 + 2, Integer.MIN_VALUE);
            guiGraphics.m_280488_(font, cascadeText, x, y, 0xFFFFFF);
        }

        @SubscribeEvent
        public static void onChunkLoad(ChunkEvent.Load event) {
            Level world = (Level)event.getLevel();
            if (!ParticularConfig.cascades() || !world.m_5776_()) {
                return;
            }
            ResourceLocation newDimension = world.m_6042_().f_63837_();
            if (Main.currentDimension != null && !newDimension.equals((Object)Main.currentDimension)) {
                Main.LOGGER.debug("Dimension changed from {} to {}, clearing cascades", (Object)Main.currentDimension, (Object)newDimension);
                Main.cascades.clear();
            }
            Main.currentDimension = newDimension;
            CompletableFuture.runAsync(() -> {
                ChunkAccess chunk = event.getChunk();
                int minX = chunk.m_7697_().m_45604_();
                int minZ = chunk.m_7697_().m_45605_();
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                ArrayList<Pair> waterBlocks = new ArrayList<Pair>();
                for (int sectionIndex = 0; sectionIndex < chunk.m_151559_(); ++sectionIndex) {
                    LevelChunkSection section = chunk.m_183278_(sectionIndex);
                    if (section == null || section.m_188008_() || !section.m_63002_(state -> state.m_60819_().m_192917_((Fluid)Fluids.f_76193_))) continue;
                    int sectionY = chunk.m_151568_(sectionIndex);
                    int baseY = sectionY << 4;
                    PalettedContainer states = section.m_63019_();
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            for (int x = 0; x < 16; ++x) {
                                BlockState state2 = (BlockState)states.m_63087_(x, y, z);
                                FluidState fluidState = state2.m_60819_();
                                if (!fluidState.m_192917_((Fluid)Fluids.f_76193_)) continue;
                                int worldX = minX + x;
                                int worldY = baseY + y;
                                int worldZ = minZ + z;
                                waterBlocks.add(Pair.of((Object)new BlockPos(worldX, worldY, worldZ), (Object)fluidState));
                            }
                        }
                    }
                }
                if (!waterBlocks.isEmpty()) {
                    Minecraft.m_91087_().execute(() -> {
                        for (Pair pair : waterBlocks) {
                            Main.updateCascade(world, (BlockPos)pair.getLeft(), (FluidState)pair.getRight());
                        }
                    });
                }
            }, Util.m_183991_());
        }

        @SubscribeEvent
        public static void onChunkUnload(ChunkEvent.Unload event) {
            if (!ParticularConfig.cascades() || !event.getLevel().m_5776_()) {
                return;
            }
            ChunkPos chunkPos = event.getChunk().m_7697_();
            int minX = chunkPos.m_45604_();
            int maxX = chunkPos.m_45608_();
            int minZ = chunkPos.m_45605_();
            int maxZ = chunkPos.m_45609_();
            Main.cascades.entrySet().removeIf(entry -> {
                BlockPos pos = (BlockPos)entry.getKey();
                return pos.m_123341_() >= minX && pos.m_123341_() <= maxX && pos.m_123343_() >= minZ && pos.m_123343_() <= maxZ;
            });
        }

        @SubscribeEvent
        public static void onLevelUnload(LevelEvent.Unload event) {
            if (event.getLevel().m_5776_()) {
                Main.cascades.clear();
            }
        }

        private static /* synthetic */ boolean lambda$onClientTick$1(BlockPos playerPos, int renderDistance, long currentTime, Level world, RandomSource random, Minecraft mc, Map.Entry entry) {
            BlockPos pos = (BlockPos)entry.getKey();
            CascadeData cascadeData = (CascadeData)entry.getValue();
            int chunkDistance = Math.max(Math.abs((pos.m_123341_() >> 4) - (playerPos.m_123341_() >> 4)), Math.abs((pos.m_123343_() >> 4) - (playerPos.m_123343_() >> 4)));
            if (chunkDistance > renderDistance) {
                return true;
            }
            if (currentTime - cascadeData.createdTime > 100L) {
                if (world.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_) && world.m_6425_(pos.m_7494_()).m_192917_((Fluid)Fluids.f_76192_) && world.m_6425_(pos.m_7495_()).m_192917_((Fluid)Fluids.f_76193_)) {
                    int strength = 0;
                    if (world.m_6425_(pos.m_122012_()).m_192917_((Fluid)Fluids.f_76193_)) {
                        ++strength;
                    }
                    if (world.m_6425_(pos.m_122029_()).m_192917_((Fluid)Fluids.f_76193_)) {
                        ++strength;
                    }
                    if (world.m_6425_(pos.m_122019_()).m_192917_((Fluid)Fluids.f_76193_)) {
                        ++strength;
                    }
                    if (world.m_6425_(pos.m_122024_()).m_192917_((Fluid)Fluids.f_76193_)) {
                        ++strength;
                    }
                    if (strength > 0) {
                        boolean isEncased;
                        boolean bl = isEncased = !world.m_8055_(pos.m_7494_().m_122012_()).m_60795_() && !world.m_8055_(pos.m_7494_().m_122029_()).m_60795_() && !world.m_8055_(pos.m_7494_().m_122019_()).m_60795_() && !world.m_8055_(pos.m_7494_().m_122024_()).m_60795_();
                        if (!isEncased) {
                            Main.cascades.put(pos, new CascadeData(strength, currentTime));
                            return false;
                        }
                    }
                }
                return true;
            }
            if (!(world.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_) && world.m_6425_(pos.m_7494_()).m_192917_((Fluid)Fluids.f_76192_) && world.m_6425_(pos.m_7495_()).m_192917_((Fluid)Fluids.f_76193_))) {
                return true;
            }
            float height = world.m_6425_(pos.m_7494_()).m_76182_();
            double x = pos.m_123341_();
            double y = (double)pos.m_123342_() + random.m_188500_() * (double)height + 1.0;
            double z = pos.m_123343_();
            if (random.m_188499_()) {
                x += random.m_188500_();
                z += (double)random.m_216332_(0, 1);
            } else {
                x += (double)random.m_216332_(0, 1);
                z += random.m_188500_();
            }
            Particle cascade = mc.f_91061_.m_107370_((ParticleOptions)Particles.CASCADE.get(), x, y, z, 0.0, 0.0, 0.0);
            if (cascade != null) {
                float size = (float)cascadeData.strength / 4.0f * height;
                cascade.m_6569_(1.0f - (1.0f - size) / 2.0f);
            }
            return false;
        }
    }
}

