/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy;

import java.util.Locale;
import java.util.Map;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.divinitycraft.divinityeconomy.DivinityModule;
import org.divinitycraft.divinityeconomy.Metrics;
import org.divinitycraft.divinityeconomy.commands.admin.BanEnchant;
import org.divinitycraft.divinityeconomy.commands.admin.BanEnchantTC;
import org.divinitycraft.divinityeconomy.commands.admin.BanItem;
import org.divinitycraft.divinityeconomy.commands.admin.BanItemTC;
import org.divinitycraft.divinityeconomy.commands.admin.ClearBal;
import org.divinitycraft.divinityeconomy.commands.admin.ClearBalTC;
import org.divinitycraft.divinityeconomy.commands.admin.ESetStock;
import org.divinitycraft.divinityeconomy.commands.admin.ESetStockTC;
import org.divinitycraft.divinityeconomy.commands.admin.ESetValue;
import org.divinitycraft.divinityeconomy.commands.admin.ESetValueTC;
import org.divinitycraft.divinityeconomy.commands.admin.EditBal;
import org.divinitycraft.divinityeconomy.commands.admin.EditBalTC;
import org.divinitycraft.divinityeconomy.commands.admin.Reload;
import org.divinitycraft.divinityeconomy.commands.admin.ReloadTC;
import org.divinitycraft.divinityeconomy.commands.admin.Save;
import org.divinitycraft.divinityeconomy.commands.admin.SaveTC;
import org.divinitycraft.divinityeconomy.commands.admin.SetBal;
import org.divinitycraft.divinityeconomy.commands.admin.SetBalTC;
import org.divinitycraft.divinityeconomy.commands.admin.SetStock;
import org.divinitycraft.divinityeconomy.commands.admin.SetStockTC;
import org.divinitycraft.divinityeconomy.commands.admin.SetValue;
import org.divinitycraft.divinityeconomy.commands.admin.SetValueTC;
import org.divinitycraft.divinityeconomy.commands.enchants.EnchantHandBuy;
import org.divinitycraft.divinityeconomy.commands.enchants.EnchantHandBuyTC;
import org.divinitycraft.divinityeconomy.commands.enchants.EnchantHandSell;
import org.divinitycraft.divinityeconomy.commands.enchants.EnchantHandSellTC;
import org.divinitycraft.divinityeconomy.commands.enchants.EnchantHandValue;
import org.divinitycraft.divinityeconomy.commands.enchants.EnchantHandValueTC;
import org.divinitycraft.divinityeconomy.commands.enchants.EnchantInfo;
import org.divinitycraft.divinityeconomy.commands.enchants.EnchantInfoTC;
import org.divinitycraft.divinityeconomy.commands.enchants.EnchantSellAll;
import org.divinitycraft.divinityeconomy.commands.enchants.EnchantSellAllTC;
import org.divinitycraft.divinityeconomy.commands.enchants.EnchantValue;
import org.divinitycraft.divinityeconomy.commands.enchants.EnchantValueTC;
import org.divinitycraft.divinityeconomy.commands.experience.ExperienceBuy;
import org.divinitycraft.divinityeconomy.commands.experience.ExperienceBuyTC;
import org.divinitycraft.divinityeconomy.commands.experience.ExperienceSell;
import org.divinitycraft.divinityeconomy.commands.experience.ExperienceSellTC;
import org.divinitycraft.divinityeconomy.commands.help.HelpCommand;
import org.divinitycraft.divinityeconomy.commands.help.HelpCommandTC;
import org.divinitycraft.divinityeconomy.commands.mail.ClearMail;
import org.divinitycraft.divinityeconomy.commands.mail.ClearMailTC;
import org.divinitycraft.divinityeconomy.commands.mail.ReadMail;
import org.divinitycraft.divinityeconomy.commands.mail.ReadMailTC;
import org.divinitycraft.divinityeconomy.commands.market.Buy;
import org.divinitycraft.divinityeconomy.commands.market.BuyTC;
import org.divinitycraft.divinityeconomy.commands.market.HandBuy;
import org.divinitycraft.divinityeconomy.commands.market.HandBuyTC;
import org.divinitycraft.divinityeconomy.commands.market.HandInfo;
import org.divinitycraft.divinityeconomy.commands.market.HandSell;
import org.divinitycraft.divinityeconomy.commands.market.HandSellTC;
import org.divinitycraft.divinityeconomy.commands.market.HandValue;
import org.divinitycraft.divinityeconomy.commands.market.HandValueTC;
import org.divinitycraft.divinityeconomy.commands.market.Info;
import org.divinitycraft.divinityeconomy.commands.market.InfoTC;
import org.divinitycraft.divinityeconomy.commands.market.ItemList;
import org.divinitycraft.divinityeconomy.commands.market.ItemListTC;
import org.divinitycraft.divinityeconomy.commands.market.Sell;
import org.divinitycraft.divinityeconomy.commands.market.SellAll;
import org.divinitycraft.divinityeconomy.commands.market.SellAllTC;
import org.divinitycraft.divinityeconomy.commands.market.SellTC;
import org.divinitycraft.divinityeconomy.commands.market.Value;
import org.divinitycraft.divinityeconomy.commands.market.ValueTC;
import org.divinitycraft.divinityeconomy.commands.misc.EconomyNotifications;
import org.divinitycraft.divinityeconomy.commands.misc.EconomyNotificationsTC;
import org.divinitycraft.divinityeconomy.commands.misc.Ping;
import org.divinitycraft.divinityeconomy.commands.money.Balance;
import org.divinitycraft.divinityeconomy.commands.money.BalanceTC;
import org.divinitycraft.divinityeconomy.commands.money.ListBalances;
import org.divinitycraft.divinityeconomy.commands.money.SendCash;
import org.divinitycraft.divinityeconomy.commands.money.SendCashTC;
import org.divinitycraft.divinityeconomy.config.ConfigManager;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.console.Console;
import org.divinitycraft.divinityeconomy.console.LogLevel;
import org.divinitycraft.divinityeconomy.economy.BaltopPlayer;
import org.divinitycraft.divinityeconomy.economy.EconomyManager;
import org.divinitycraft.divinityeconomy.help.HelpManager;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.lang.LangManager;
import org.divinitycraft.divinityeconomy.mail.MailManager;
import org.divinitycraft.divinityeconomy.market.exp.ExpManager;
import org.divinitycraft.divinityeconomy.market.items.enchants.EnchantManager;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketManager;
import org.divinitycraft.divinityeconomy.market.items.materials.block.BlockManager;
import org.divinitycraft.divinityeconomy.market.items.materials.entity.EntityManager;
import org.divinitycraft.divinityeconomy.market.items.materials.potion.PotionManager;
import org.divinitycraft.divinityeconomy.migrators.MigrationManager;
import org.divinitycraft.divinityeconomy.placeholders.ExpansionManager;
import org.divinitycraft.divinityeconomy.player.PlayerManager;
import org.divinitycraft.divinityeconomy.world.WorldManager;

public class DEPlugin
extends JavaPlugin {
    private final int bStatsID = 22013;
    private final String defaultLocaleString = "en_GB";
    private ConfigManager config;
    private Console console;
    private LangManager lang;
    private WorldManager worldManager;
    private EconomyManager economyManager;
    private MailManager mailManager;
    private PlayerManager playerManager;
    private HelpManager helpManager;
    private MarketManager marketManager;
    private BlockManager blockManager;
    private EntityManager entityManager;
    private PotionManager potionManager;
    private EnchantManager enchantManager;
    private ExpManager expManager;
    private ExpansionManager expansionManager;
    private MigrationManager migrationManager;
    private Metrics metrics;

    public void onEnable() {
        Locale.setDefault(Locale.of("en_GB"));
        LogLevel.loadValuesFromConfig((YamlConfiguration)this.getConfig());
        this.config = new ConfigManager(this);
        this.console = new Console(this);
        this.lang = new LangManager(this);
        this.migrationManager = new MigrationManager(this);
        this.worldManager = new WorldManager(this);
        this.playerManager = new PlayerManager(this);
        this.economyManager = new EconomyManager(this);
        this.marketManager = new MarketManager(this);
        this.blockManager = new BlockManager(this);
        this.potionManager = new PotionManager(this);
        this.entityManager = new EntityManager(this);
        this.enchantManager = new EnchantManager(this);
        this.expManager = new ExpManager(this);
        this.mailManager = new MailManager(this);
        this.helpManager = new HelpManager(this);
        this.config.init();
        DivinityModule.addModule(this.config, true);
        try {
            Locale configLocale = Locale.of(this.getConfMan().getString(Setting.MAIN_SYSTEM_LOCALE_STRING));
            Locale.setDefault(configLocale);
        }
        catch (Exception e) {
            this.console.warn(LangEntry.GENERIC_LocaleError.get(this), this.getConfMan().getString(Setting.MAIN_SYSTEM_LOCALE_STRING));
            e.printStackTrace();
        }
        this.lang.init();
        DivinityModule.addModule(this.lang, true);
        this.migrationManager.init();
        DivinityModule.addModule(this.migrationManager, true);
        this.worldManager.init();
        DivinityModule.addModule(this.worldManager, true);
        this.playerManager.init();
        DivinityModule.addModule(this.playerManager, true);
        this.economyManager.init();
        if (this.economyManager.getVaultEconomy() == null) {
            this.console.severe(LangEntry.GENERIC_EconomyNotEnabled.get(this), new Object[0]);
            this.shutdown();
            return;
        }
        this.console.info(LangEntry.GENERIC_EconomyEnabled.get(this), this.economyManager.getVaultEconomy());
        DivinityModule.addModule(this.economyManager, true);
        DivinityModule.runInit();
        if (!this.getLang().isUsingDefaultLang()) {
            this.getConsole().warn(LangEntry.GENERIC_LanguagePlea.get(this), new Object[0]);
        }
        new ClearBal(this);
        new ClearBalTC(this);
        new EditBal(this);
        new EditBalTC(this);
        new ESetStock(this);
        new ESetStockTC(this);
        new ESetValue(this);
        new ESetValueTC(this);
        new Reload(this);
        new ReloadTC(this);
        new Save(this);
        new SaveTC(this);
        new SetBal(this);
        new SetBalTC(this);
        new SetStock(this);
        new SetStockTC(this);
        new SetValue(this);
        new SetValueTC(this);
        new Reload(this);
        new BanItem(this);
        new BanItemTC(this);
        new BanEnchant(this);
        new BanEnchantTC(this);
        new ExperienceBuy(this);
        new ExperienceBuyTC(this);
        new ExperienceSell(this);
        new ExperienceSellTC(this);
        new EnchantHandBuy(this);
        new EnchantHandBuyTC(this);
        new EnchantHandSell(this);
        new EnchantHandSellTC(this);
        new EnchantHandValue(this);
        new EnchantHandValueTC(this);
        new EnchantInfo(this);
        new EnchantInfoTC(this);
        new EnchantValue(this);
        new EnchantValueTC(this);
        new EnchantSellAll(this);
        new EnchantSellAllTC(this);
        new HelpCommand(this);
        new HelpCommandTC(this);
        new ClearMail(this);
        new ClearMailTC(this);
        new ReadMail(this);
        new ReadMailTC(this);
        new Buy(this);
        new BuyTC(this);
        new HandBuy(this);
        new HandBuyTC(this);
        new HandInfo(this);
        new HandSell(this);
        new HandSellTC(this);
        new HandValue(this);
        new HandValueTC(this);
        new Info(this);
        new InfoTC(this);
        new Sell(this);
        new SellTC(this);
        new SellAll(this);
        new SellAllTC(this);
        new Value(this);
        new ValueTC(this);
        new ItemList(this);
        new ItemListTC(this);
        new Ping(this);
        new EconomyNotifications(this);
        new EconomyNotificationsTC(this);
        new Balance(this);
        new BalanceTC(this);
        new SendCash(this);
        new SendCashTC(this);
        new ListBalances(this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            if (this.getConfMan().getBoolean(Setting.MAIN_ENABLE_PAPI_BOOLEAN).booleanValue()) {
                this.expansionManager = new ExpansionManager(this);
                this.expansionManager.register();
                this.getConsole().info(LangEntry.GENERIC_PAPIEnabled.get(this), this.expansionManager.getExpansionCount());
            } else {
                this.getConsole().warn(LangEntry.GENERIC_PAPINotEnabled.get(this), new Object[0]);
            }
        } else {
            this.getConsole().warn(LangEntry.GENERIC_PAPINotFound.get(this), new Object[0]);
        }
        if (this.getConfMan().getBoolean(Setting.MAIN_ENABLE_BSTATS_BOOLEAN).booleanValue()) {
            this.enableMetrics();
        }
        this.describe();
        this.console.severe(LangEntry.GENERIC_PluginEnabled.get(this), new Object[0]);
    }

    public void onDisable() {
        DivinityModule.runDeinit();
        this.metrics.shutdown();
        this.console.severe(LangEntry.GENERIC_PluginDisabled.get(this), new Object[0]);
    }

    public void shutdown() {
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    public void describe() {
        this.console.debug(LangEntry.DESCRIBE_Header.get(this), new Object[0]);
        this.console.debug(LangEntry.ECONOMY_Prefix.get(this), this.console.getCurrencyPrefix());
        this.console.debug(LangEntry.ECONOMY_Suffix.get(this), this.console.getCurrencySuffix());
        this.console.debug(LangEntry.DESCRIBE_Settings.get(this), new Object[0]);
        for (Setting setting : Setting.values()) {
            Object value = this.getConfMan().get(setting);
            if (value instanceof MemorySection) continue;
            this.getConsole().debug("   - %s: '%s'", setting.path, value);
        }
        this.console.debug("", new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_Markets.get(this), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_Materials.get(this, this.blockManager.getItemCount()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_MaterialMarketSize.get(this, this.blockManager.getTotalItems(), this.blockManager.getDefaultTotalItems()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_MaterialMarketInflation.get(this, this.blockManager.getInflation()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_Enchants.get(this, this.enchantManager.getEnchantCount()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_EnchantMarketSize.get(this, this.enchantManager.getTotalItems(), this.enchantManager.getDefaultTotalItems()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_EnchantMarketInflation.get(this, this.enchantManager.getInflation()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_Experience.get(this, this.expManager.getItemCount()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_ExperienceMarketSize.get(this, this.expManager.getTotalItems(), this.expManager.getDefaultTotalItems()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_ExperienceMarketInflation.get(this, this.expManager.getInflation()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_PotionsMarketInflation.get(this, this.potionManager.getItemCount()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_PotionsMarketInflation.get(this, this.potionManager.getTotalItems(), this.potionManager.getDefaultTotalItems()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_PotionsMarketInflation.get(this, this.potionManager.getInflation()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_EntitiesMarketInflation.get(this, this.entityManager.getItemCount()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_EntitiesMarketInflation.get(this, this.entityManager.getTotalItems(), this.entityManager.getDefaultTotalItems()), new Object[0]);
        this.console.debug(LangEntry.DESCRIBE_EntitiesMarketInflation.get(this, this.entityManager.getInflation()), new Object[0]);
        this.console.debug("", new Object[0]);
    }

    public void enableMetrics() {
        this.metrics = new Metrics((Plugin)this, 22013);
        this.metrics.addCustomChart(new Metrics.SimplePie("locale", () -> {
            this.getConsole().debug("Fetching locale for bStats.", new Object[0]);
            return this.getLang().getSelectedLangStats();
        }));
        if (this.getEconMan().getTotalEconomySize() > 0.0) {
            this.metrics.addCustomChart(new Metrics.SingleLineChart("economy_size", () -> {
                this.getConsole().debug("Fetching economy size for bStats.", new Object[0]);
                return (int)this.getEconMan().getTotalEconomySize();
            }));
            this.metrics.addCustomChart(new Metrics.SingleLineChart("economy_inflation", () -> {
                this.getConsole().debug("Fetching economy inflation for bStats.", new Object[0]);
                return (int)this.getMarkMan().getInflation();
            }));
            this.metrics.addCustomChart(new Metrics.SingleLineChart("economy_size_per_capita", () -> {
                this.getConsole().debug("Fetching economy size per capita for bStats.", new Object[0]);
                return (int)this.getEconMan().getEconomySizePerCapita();
            }));
            this.metrics.addCustomChart(new Metrics.SingleLineChart("economy_equality", () -> {
                this.getConsole().debug("Fetching economy equality for bStats.", new Object[0]);
                return this.getEconMan().getEconomyEquality();
            }));
            this.metrics.addCustomChart(new Metrics.AdvancedPie("richest_players", () -> {
                this.getConsole().debug("Fetching richest players for bStats.", new Object[0]);
                BaltopPlayer player = this.getEconMan().getRichestPlayer();
                if (player != null) {
                    return Map.of(player.getName(), (int)player.getBalance());
                }
                return Map.of("", 0);
            }));
            this.metrics.addCustomChart(new Metrics.AdvancedPie("economy_distribution_1", () -> {
                this.getConsole().debug("Fetching economy distribution 1 for bStats.", new Object[0]);
                double balance = this.getEconMan().getTotalEconomySize();
                double top20 = this.getEconMan().getTopPercentileBalance(20) / balance * 100.0;
                double bottom80 = this.getEconMan().getBottomPercentileBalance(80) / balance * 100.0;
                return Map.of("Top 20%", (int)top20, "Bottom 80%", (int)bottom80);
            }));
            this.metrics.addCustomChart(new Metrics.AdvancedPie("economy_distribution_2", () -> {
                this.getConsole().debug("Fetching economy distribution 2 for bStats.", new Object[0]);
                double balance = this.getEconMan().getTotalEconomySize();
                double top1 = this.getEconMan().getTopPercentileBalance(1) / balance * 100.0;
                double top10 = (this.getEconMan().getTopPercentileBalance(10) - top1) / balance * 100.0;
                double top50 = (this.getEconMan().getTopPercentileBalance(50) - top10) / balance * 100.0;
                double bottom50 = this.getEconMan().getBottomPercentileBalance(50) / balance * 100.0;
                return Map.of("Top 1%", (int)top1, "Top 10%", (int)top10, "Top 50%", (int)top50, "Bottom 50%", (int)bottom50);
            }));
        }
    }

    public ConfigManager getConfMan() {
        return this.config;
    }

    public Console getConsole() {
        return this.console;
    }

    public LangManager getLang() {
        return this.lang;
    }

    public WorldManager getWorldMan() {
        return this.worldManager;
    }

    public EconomyManager getEconMan() {
        return this.economyManager;
    }

    public MarketManager getMarkMan() {
        return this.marketManager;
    }

    public BlockManager getMatMan() {
        return this.blockManager;
    }

    public PotionManager getPotMan() {
        return this.potionManager;
    }

    public EntityManager getEntMan() {
        return this.entityManager;
    }

    public ExpManager getExpMan() {
        return this.expManager;
    }

    public MailManager getMailMan() {
        return this.mailManager;
    }

    public PlayerManager getPlayMan() {
        return this.playerManager;
    }

    public EnchantManager getEnchMan() {
        return this.enchantManager;
    }

    public HelpManager getHelpMan() {
        return this.helpManager;
    }

    public ExpansionManager getExpansionManager() {
        return this.expansionManager;
    }
}

