/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.logging.Logger;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.config.ConfigManager;
import org.divinitycraft.divinityeconomy.console.Console;
import org.divinitycraft.divinityeconomy.economy.EconomyManager;
import org.divinitycraft.divinityeconomy.help.HelpManager;
import org.divinitycraft.divinityeconomy.lang.LangManager;
import org.divinitycraft.divinityeconomy.mail.MailManager;
import org.divinitycraft.divinityeconomy.market.exp.ExpManager;
import org.divinitycraft.divinityeconomy.market.items.enchants.EnchantManager;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketManager;
import org.divinitycraft.divinityeconomy.market.items.materials.block.BlockManager;
import org.divinitycraft.divinityeconomy.market.items.materials.entity.EntityManager;
import org.divinitycraft.divinityeconomy.market.items.materials.potion.PotionManager;
import org.divinitycraft.divinityeconomy.player.PlayerManager;
import org.divinitycraft.divinityeconomy.world.WorldManager;

public abstract class DivinityModule {
    private static final Logger logger = Logger.getLogger("Minecraft");
    private static final Queue<DivinityModule> modules = new ArrayDeque<DivinityModule>();
    private static final Queue<DivinityModule> initialisedModules = new ArrayDeque<DivinityModule>();
    private final DEPlugin main;

    public DivinityModule(DEPlugin main) {
        this.main = main;
        modules.add(this);
    }

    public DivinityModule(DEPlugin main, boolean addInit) {
        this.main = main;
        if (addInit) {
            modules.add(this);
        }
    }

    public static void runInit() {
        for (DivinityModule module : modules) {
            if (initialisedModules.contains(module)) continue;
            try {
                module.init();
                initialisedModules.add(module);
            }
            catch (Exception e) {
                logger.severe(String.format("Module '%s' failed to initialise: %s", module.getClass().getName(), e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public static void runDeinit() {
        while (!initialisedModules.isEmpty()) {
            DivinityModule module = initialisedModules.remove();
            try {
                module.deinit();
            }
            catch (Exception e) {
                logger.severe(String.format("Module '%s' failed to deinitialise: %s", module.getClass().getName(), e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public static void addModule(DivinityModule module, boolean isInitiated) {
        if (module == null) {
            return;
        }
        if (!modules.contains(module)) {
            modules.add(module);
        }
        if (isInitiated && !initialisedModules.contains(module)) {
            initialisedModules.add(module);
        }
    }

    protected abstract void init();

    protected abstract void deinit();

    public HelpManager getHelpMan() {
        return this.getMain().getHelpMan();
    }

    public EnchantManager getEnchMan() {
        return this.getMain().getEnchMan();
    }

    public BlockManager getMatMan() {
        return this.getMain().getMatMan();
    }

    public PotionManager getPotMan() {
        return this.getMain().getPotMan();
    }

    public EntityManager getEntMan() {
        return this.getMain().getEntMan();
    }

    public ExpManager getExpMan() {
        return this.getMain().getExpMan();
    }

    public WorldManager getWorldMan() {
        return this.getMain().getWorldMan();
    }

    public MarketManager getMarkMan() {
        return this.getMain().getMarkMan();
    }

    public ConfigManager getConfMan() {
        return this.getMain().getConfMan();
    }

    public EconomyManager getEconMan() {
        return this.getMain().getEconMan();
    }

    public MailManager getMailMan() {
        return this.getMain().getMailMan();
    }

    public PlayerManager getPlayMan() {
        return this.getMain().getPlayMan();
    }

    public LangManager getLang() {
        return this.getMain().getLang();
    }

    public Console getConsole() {
        return this.getMain().getConsole();
    }

    public DEPlugin getMain() {
        return this.main;
    }
}

