/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.help.Help;
import org.divinitycraft.divinityeconomy.lang.LangEntry;

public abstract class DivinityCommand
implements CommandExecutor {
    protected final Help help;
    protected final boolean isEnabled;
    protected final boolean hasConsoleSupport;
    protected boolean checkEconomyEnabled = false;
    protected boolean checkEnchantMarketEnabled = false;
    protected boolean checkItemMarketEnabled = false;
    protected boolean checkExperienceMarketEnabled = false;
    protected boolean checkPermissions = true;
    private final PluginCommand command;
    private final DEPlugin main;

    public DivinityCommand(DEPlugin main, String registeredCommandName, boolean hasConsoleSupport, boolean isEnabled) {
        this.main = main;
        this.help = this.getMain().getHelpMan().get(registeredCommandName);
        this.hasConsoleSupport = hasConsoleSupport;
        this.isEnabled = isEnabled;
        this.command = this.getMain().getCommand(registeredCommandName);
        if (this.command == null) {
            this.getMain().getConsole().warn("Command Executor '%s' is incorrectly setup", registeredCommandName);
        } else {
            this.command.setExecutor((CommandExecutor)this);
            if (!this.getMain().getConfMan().getBoolean(Setting.IGNORE_COMMAND_REGISTRY_BOOLEAN).booleanValue()) {
                this.getMain().getConsole().info("Command %s registered", registeredCommandName);
            }
        }
    }

    public DivinityCommand(DEPlugin main, String registeredCommandName, boolean hasConsoleSupport, Setting commandSetting) {
        this(main, registeredCommandName, hasConsoleSupport, main.getConfMan().getBoolean(commandSetting));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        try {
            if (sender instanceof Player) {
                this._onPlayerCommand((Player)sender, args);
            } else {
                this._onConsoleCommand(args);
            }
            return true;
        }
        catch (Exception e) {
            this.getMain().getConsole().send(LangEntry.GENERIC_ErrorOnCommand.logLevel, LangEntry.GENERIC_ErrorOnCommand.get(this.getMain()), command, e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    public boolean _onPlayerCommand(Player sender, String[] args) {
        if (!this.isEnabled) {
            this.returnCommandDisabled(sender);
            return true;
        }
        if (this.checkPermissions && !this.command.testPermission((CommandSender)sender)) {
            this.returnPlayerNoPermission(sender);
            return true;
        }
        if (this.checkEconomyEnabled && !this.checkEconomyEnabledInWorld(sender)) {
            this.getMain().getConsole().send(sender, LangEntry.WORLDS_EconomyDisabledInThisWorld.logLevel, LangEntry.WORLDS_EconomyDisabledInThisWorld.get(this.getMain()), new Object[0]);
            return true;
        }
        if ((this.checkItemMarketEnabled || this.checkEnchantMarketEnabled || this.checkExperienceMarketEnabled) && !this.checkMarketEnabledInWorld(sender)) {
            this.getMain().getConsole().send(sender, LangEntry.WORLDS_MarketDisabledInThisWorld.logLevel, LangEntry.WORLDS_MarketDisabledInThisWorld.get(this.getMain()), new Object[0]);
            return true;
        }
        if (this.checkItemMarketEnabled && !this.checkItemMarketEnabledInWorld(sender)) {
            this.getMain().getConsole().send(sender, LangEntry.WORLDS_ItemMarketDisabledInThisWorld.logLevel, LangEntry.WORLDS_ItemMarketDisabledInThisWorld.get(this.getMain()), new Object[0]);
            return true;
        }
        if (this.checkEnchantMarketEnabled && !this.checkEnchantMarketEnabledInWorld(sender)) {
            this.getMain().getConsole().send(sender, LangEntry.WORLDS_EnchantMarketDisabledInThisWorld.logLevel, LangEntry.WORLDS_EnchantMarketDisabledInThisWorld.get(this.getMain()), new Object[0]);
            return true;
        }
        if (this.checkExperienceMarketEnabled && !this.checkExperienceMarketEnabledInWorld(sender)) {
            this.getMain().getConsole().send(sender, LangEntry.WORLDS_ExperienceMarketDisabledInThisWorld.logLevel, LangEntry.WORLDS_ExperienceMarketDisabledInThisWorld.get(this.getMain()), new Object[0]);
        }
        return this.onPlayerCommand(sender, args);
    }

    public void returnCommandDisabled(Player sender) {
        this.getMain().getConsole().send(sender, LangEntry.GENERIC_PlayerCommandIsDisabled.logLevel, LangEntry.GENERIC_PlayerCommandIsDisabled.get(this.getMain()), new Object[0]);
    }

    public void returnPlayerNoPermission(Player sender) {
        this.getMain().getConsole().send(sender, LangEntry.GENERIC_PlayerNoPermission.logLevel, LangEntry.GENERIC_PlayerNoPermission.get(this.getMain()), new Object[0]);
    }

    public abstract boolean onPlayerCommand(Player var1, String[] var2);

    public boolean _onConsoleCommand(String[] args) {
        if (!this.isEnabled) {
            this.returnCommandDisabled(null);
            return true;
        }
        if (!this.hasConsoleSupport) {
            this.getMain().getConsole().send(LangEntry.GENERIC_ConsoleSupportNotAdded.logLevel, LangEntry.GENERIC_ConsoleSupportNotAdded.get(this.getMain()), new Object[0]);
            return true;
        }
        return this.onConsoleCommand(args);
    }

    public abstract boolean onConsoleCommand(String[] var1);

    public boolean checkEconomyEnabledInWorld(Player player) {
        return this.getMain().getWorldMan().isEconomyEnabled(player.getWorld());
    }

    public boolean checkMarketEnabledInWorld(Player player) {
        return this.getMain().getWorldMan().isMarketEnabled(player.getWorld());
    }

    public boolean checkEnchantMarketEnabledInWorld(Player player) {
        return this.getMain().getWorldMan().isEnchantMarketEnabled(player.getWorld());
    }

    public boolean checkItemMarketEnabledInWorld(Player player) {
        return this.getMain().getWorldMan().isItemMarketEnabled(player.getWorld());
    }

    public boolean checkExperienceMarketEnabledInWorld(Player player) {
        return this.getMain().getWorldMan().isExperienceMarketEnabled(player.getWorld());
    }

    public DEPlugin getMain() {
        return this.main;
    }
}

