/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands;

import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;

public abstract class DivinityCommandTC
implements TabCompleter {
    protected final boolean isEnabled;
    protected final boolean hasConsoleSupport;
    private final DEPlugin main;

    public DivinityCommandTC(DEPlugin main, String registeredCommandName, boolean hasConsoleSupport, Setting commandSetting) {
        this.main = main;
        this.hasConsoleSupport = hasConsoleSupport;
        this.isEnabled = this.main.getConfig().getBoolean(commandSetting.path);
        PluginCommand command = this.getMain().getCommand(registeredCommandName);
        if (command == null) {
            this.getMain().getConsole().warn("Command TabCompleter '%s' is incorrectly setup", registeredCommandName);
        } else {
            if (this.isEnabled) {
                command.setTabCompleter((TabCompleter)this);
            }
            if (!this.getMain().getConfMan().getBoolean(Setting.IGNORE_COMMAND_REGISTRY_BOOLEAN).booleanValue()) {
                this.getMain().getConsole().info("CommandTC %s registered", registeredCommandName);
            }
        }
    }

    protected DEPlugin getMain() {
        return this.main;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        try {
            if (sender instanceof Player) {
                return this._onPlayerTabComplete((Player)sender, args);
            }
            return this._onConsoleTabComplete(args);
        }
        catch (Exception e) {
            this.main.getConsole().send(LangEntry.GENERIC_ErrorOnCommand.logLevel, LangEntry.GENERIC_ErrorOnCommand.get(this.getMain()), this.getClass().getName(), e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public List<String> _onPlayerTabComplete(Player sender, String[] args) {
        if (!this.isEnabled) {
            return null;
        }
        return this.onPlayerTabCompleter(sender, args);
    }

    public abstract List<String> onPlayerTabCompleter(Player var1, String[] var2);

    public List<String> _onConsoleTabComplete(String[] args) {
        if (!this.isEnabled) {
            return null;
        }
        if (!this.hasConsoleSupport) {
            return null;
        }
        return this.onConsoleTabCompleter(args);
    }

    public abstract List<String> onConsoleTabCompleter(String[] var1);
}

