/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.admin;

import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.enchants.MarketableEnchant;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class BanEnchant
extends DivinityCommand {
    public BanEnchant(DEPlugin app) {
        super(app, "banenchant", true, Setting.COMMAND_BAN_ENCHANT_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        boolean isBanned;
        MarketableEnchant enchantData;
        switch (args.length) {
            case 2: {
                enchantData = this.getMain().getEnchMan().getEnchant(args[0]);
                isBanned = Converter.getBoolean(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (enchantData == null) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidEnchantName.logLevel, LangEntry.MARKET_InvalidItemName.get(this.getMain()), args[0]);
            return true;
        }
        enchantData.getManager().setAllowed(enchantData, !isBanned);
        this.getMain().getConsole().send(sender, LangEntry.STOCK_BannedStatusChanged.logLevel, LangEntry.STOCK_BannedStatusChanged.get(this.getMain()), enchantData.getName(), isBanned);
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return this.onPlayerCommand(null, args);
    }
}

