/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.admin;

import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class BanItem
extends DivinityCommand {
    public BanItem(DEPlugin app) {
        super(app, "banitem", true, Setting.COMMAND_BAN_ITEM_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        boolean isBanned;
        MarketableMaterial marketableMaterial;
        switch (args.length) {
            case 2: {
                marketableMaterial = this.getMain().getMarkMan().getItem(args[0]);
                isBanned = Converter.getBoolean(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (marketableMaterial == null) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidItemName.logLevel, LangEntry.MARKET_InvalidItemName.get(this.getMain()), args[0]);
            return true;
        }
        marketableMaterial.getManager().setAllowed(marketableMaterial, !isBanned);
        this.getMain().getConsole().send(sender, LangEntry.STOCK_BannedStatusChanged.logLevel, LangEntry.STOCK_BannedStatusChanged.get(this.getMain()), marketableMaterial.getName(), isBanned);
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return this.onPlayerCommand(null, args);
    }
}

