/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.admin;

import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class SetBal
extends DivinityCommand {
    public SetBal(DEPlugin app) {
        super(app, "setbal", true, Setting.COMMAND_SET_BALANCE_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        double amount;
        Player receiver;
        switch (args.length) {
            case 1: {
                receiver = sender;
                amount = Converter.getDouble(args[0]);
                break;
            }
            case 2: {
                amount = Converter.getDouble(args[1]);
                receiver = this.getMain().getPlayMan().getPlayer(args[0], false);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (receiver == null) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidPlayerName.logLevel, LangEntry.GENERIC_InvalidPlayerName.get(this.getMain()), new Object[0]);
            return true;
        }
        double startingBalance = this.getMain().getEconMan().getBalance((OfflinePlayer)receiver);
        EconomyResponse response = this.getMain().getEconMan().setCash((OfflinePlayer)receiver, amount);
        if (response.transactionSuccess()) {
            this.getMain().getConsole().logBalance((OfflinePlayer)sender, (OfflinePlayer)receiver, startingBalance, response.balance, LangEntry.BALANCE_SetByPlayer.get(this.getMain(), sender.getName()));
        } else {
            this.getMain().getConsole().logFailedBalance((OfflinePlayer)sender, (OfflinePlayer)receiver, response.errorMessage);
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        OfflinePlayer receiver;
        double amount;
        switch (args.length) {
            case 2: {
                amount = Converter.getDouble(args[1]);
                receiver = this.getMain().getPlayMan().getPlayer(args[0], false);
                break;
            }
            default: {
                this.getMain().getConsole().usage(LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (receiver == null) {
            this.getMain().getConsole().send(LangEntry.GENERIC_InvalidPlayerName.logLevel, LangEntry.GENERIC_InvalidPlayerName.get(this.getMain()), new Object[0]);
            return true;
        }
        double startingBalance = this.getMain().getEconMan().getBalance(receiver);
        EconomyResponse response = this.getMain().getEconMan().setCash(receiver, amount);
        if (response.transactionSuccess()) {
            this.getMain().getConsole().logBalance(null, receiver, startingBalance, response.balance, LangEntry.BALANCE_SetByConsole.get(this.getMain()));
        } else {
            this.getMain().getConsole().logFailedBalance(null, receiver, response.errorMessage);
        }
        return true;
    }
}

