/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.enchants;

import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandEnchant;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.ItemManager;
import org.divinitycraft.divinityeconomy.market.items.enchants.EnchantValueResponse;
import org.divinitycraft.divinityeconomy.market.items.enchants.MarketableEnchant;
import org.divinitycraft.divinityeconomy.player.PlayerManager;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class EnchantHandSell
extends DivinityCommandEnchant {
    public EnchantHandSell(DEPlugin app) {
        super(app, "esell", false, Setting.COMMAND_E_SELL_ENABLE_BOOLEAN);
        this.checkEnchantMarketEnabled = true;
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        EnchantValueResponse evr;
        ItemStack heldItem;
        String enchantName;
        int enchantLevels = 1;
        boolean sellAllLevels = false;
        boolean sellAllEnchants = false;
        switch (args.length) {
            case 1: {
                enchantName = args[0];
                if (!LangEntry.W_max.is(this.getMain(), enchantName)) break;
                sellAllEnchants = true;
                sellAllLevels = true;
                break;
            }
            case 2: {
                enchantName = args[0];
                enchantLevels = Converter.getInt(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if ((heldItem = PlayerManager.getHeldItem(sender)) == null) {
            this.getMain().getConsole().usage(sender, LangEntry.MARKET_InvalidItemHeld.get(this.getMain()), this.help.getUsages());
            return true;
        }
        if (heldItem.getAmount() > 1) {
            this.getMain().getConsole().warn(sender, LangEntry.MARKET_EnchantsInvalidItemAmount.get(this.getMain()), new Object[0]);
            return true;
        }
        if (!this.getMain().getEnchMan().isEnchanted(heldItem)) {
            this.getMain().getConsole().usage(sender, LangEntry.MARKET_InvalidItemHeld.get(this.getMain()), this.help.getUsages());
            return true;
        }
        ItemStack heldItemCopy = ItemManager.clone(heldItem);
        if (sellAllEnchants) {
            EnchantValueResponse evr2 = this.getMain().getEnchMan().getSellValue(new ItemStack[]{heldItem});
            if (evr2.isFailure()) {
                this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, evr2.getQuantity(), LangEntry.MARKET_EnchantList.get(this.getMain(), evr2.listNames()), evr2.getErrorMessage());
                return true;
            }
            for (String enchantID : evr2.getTokenIds()) {
                MarketableEnchant enchantmentData = this.getMain().getEnchMan().getEnchant(enchantID);
                this.getMain().getEnchMan().editLevelQuantity(enchantmentData, evr2.getQuantity(enchantID));
                this.getMain().getEnchMan().removeEnchantLevelsFromItem(heldItem, enchantmentData.getEnchantment(), evr2.getQuantity(enchantID));
            }
            EconomyResponse economyResponse = this.getMain().getEconMan().addCash((OfflinePlayer)sender, evr2.getValue());
            if (!economyResponse.transactionSuccess()) {
                PlayerManager.replaceItemStack(sender, heldItem, heldItemCopy);
                this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, evr2.getQuantity(), LangEntry.MARKET_EnchantList.get(this.getMain(), evr2.listNames()), economyResponse.errorMessage);
                return true;
            }
            this.getMain().getConsole().logSale((OfflinePlayer)sender, evr2.getQuantity(), evr2.getValue(), LangEntry.MARKET_EnchantList.get(this.getMain(), evr2.listNames()));
            return true;
        }
        MarketableEnchant enchantData = this.getMain().getEnchMan().getEnchant(enchantName);
        if (enchantData == null) {
            this.getMain().getConsole().usage(sender, String.format(LangEntry.MARKET_InvalidEnchantName.get(this.getMain()), enchantName), this.help.getUsages());
            return true;
        }
        if (sellAllLevels) {
            enchantLevels = heldItem.getEnchantmentLevel(enchantData.getEnchantment());
        }
        if ((evr = this.getMain().getEnchMan().getSellValue(heldItem, enchantData.getID(), enchantLevels)).isFailure()) {
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, enchantLevels, enchantData.getName(), evr.getErrorMessage());
            return true;
        }
        this.getMain().getEnchMan().removeEnchantLevelsFromItem(heldItem, enchantData.getEnchantment(), enchantLevels);
        EconomyResponse economyResponse = this.getMain().getEconMan().addCash((OfflinePlayer)sender, evr.getValue());
        if (!economyResponse.transactionSuccess()) {
            PlayerManager.replaceItemStack(sender, heldItem, heldItemCopy);
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, enchantLevels, enchantData.getName(), economyResponse.errorMessage);
            return true;
        }
        this.getMain().getEnchMan().editLevelQuantity(enchantData, enchantLevels);
        this.getMain().getConsole().logSale((OfflinePlayer)sender, enchantLevels, evr.getValue(), enchantData.getName());
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

