/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.enchants;

import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandEnchant;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.MarketableToken;
import org.divinitycraft.divinityeconomy.market.items.enchants.EnchantValueResponse;
import org.divinitycraft.divinityeconomy.market.items.enchants.MarketableEnchant;
import org.divinitycraft.divinityeconomy.player.PlayerManager;

public class EnchantHandValue
extends DivinityCommandEnchant {
    public EnchantHandValue(DEPlugin app) {
        super(app, "ehandvalue", false, Setting.COMMAND_E_VALUE_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        ItemStack heldItem = PlayerManager.getHeldItem(sender);
        if (heldItem == null) {
            this.getMain().getConsole().usage(sender, LangEntry.MARKET_InvalidItemHeld.get(this.getMain()), this.help.getUsages());
            return true;
        }
        if (!this.getMain().getEnchMan().isEnchanted(heldItem)) {
            this.getMain().getConsole().usage(sender, LangEntry.MARKET_InvalidItemHeld.get(this.getMain()), this.help.getUsages());
            return true;
        }
        EnchantValueResponse evr1 = this.getMain().getEnchMan().getBuyValue(heldItem, 0);
        if (evr1.isFailure()) {
            this.getMain().getConsole().warn(sender, LangEntry.PURCHASE_ValueEnchantFailure.get(this.getMain()), evr1.getQuantity(), evr1.listNames(), evr1.getErrorMessage());
        }
        this.getMain().getConsole().info(sender, LangEntry.PURCHASE_ValueEnchantSummary.get(this.getMain()), evr1.getQuantity(), this.getMain().getConsole().formatMoney(evr1.getValue()));
        for (MarketableToken token1 : evr1.getTokens()) {
            MarketableEnchant enchant1 = (MarketableEnchant)token1;
            this.getMain().getConsole().info(sender, LangEntry.PURCHASE_ValueEnchant.get(this.getMain()), evr1.getQuantity(enchant1), enchant1.getName(), this.getMain().getConsole().formatMoney(evr1.getValue(enchant1)));
        }
        EnchantValueResponse evr2 = this.getMain().getEnchMan().getSellValue(heldItem, 0);
        if (evr2.isFailure()) {
            this.getMain().getConsole().warn(sender, LangEntry.SALE_ValueEnchantFailure.get(this.getMain()), evr2.getQuantity(), evr2.listNames(), evr2.getErrorMessage());
        }
        this.getMain().getConsole().info(sender, LangEntry.SALE_ValueEnchantSummary.get(this.getMain()), evr2.getQuantity(), this.getMain().getConsole().formatMoney(evr2.getValue()));
        for (MarketableToken token2 : evr2.getTokens()) {
            MarketableEnchant enchant2 = (MarketableEnchant)token2;
            this.getMain().getConsole().info(sender, LangEntry.SALE_ValueEnchant.get(this.getMain()), evr2.getQuantity(enchant2), enchant2.getName(), this.getMain().getConsole().formatMoney(evr2.getValue(enchant2)));
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

