/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.enchants;

import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandEnchant;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.enchants.MarketableEnchant;

public class EnchantInfo
extends DivinityCommandEnchant {
    public EnchantInfo(DEPlugin app) {
        super(app, "einfo", true, Setting.COMMAND_E_INFO_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        String enchantName;
        switch (args.length) {
            case 1: {
                enchantName = args[0];
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        MarketableEnchant enchantData = this.getMain().getEnchMan().getEnchant(enchantName);
        if (enchantData == null) {
            this.getMain().getConsole().usage(sender, LangEntry.MARKET_UnknownEnchant.get(this.getMain(), enchantName), this.help.getUsages());
        } else {
            this.getMain().getConsole().info(sender, LangEntry.INFO_InformationFor.get(this.getMain()), enchantData.getName());
            this.getMain().getConsole().info(sender, LangEntry.INFO_IDInformation.get(this.getMain()), enchantData.getID());
            this.getMain().getConsole().info(sender, LangEntry.INFO_CurrentQuantityInformation.get(this.getMain()), enchantData.getQuantity());
            this.getMain().getConsole().info(sender, LangEntry.INFO_IsBannedInformation.get(this.getMain()), !enchantData.getAllowed());
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return this.onPlayerCommand(null, args);
    }
}

