/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.help;

import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.help.Help;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class HelpCommand
extends DivinityCommand {
    public HelpCommand(DEPlugin app) {
        super(app, "ehelp", true, Setting.COMMAND_EHELP_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        int pageNumber = 0;
        String term = "";
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                pageNumber = Converter.getInt(args[0]);
                if (pageNumber != 0) break;
                term = args[0];
                break;
            }
            case 2: {
                term = args[0];
                pageNumber = Converter.getInt(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
            }
        }
        Help help = this.getMain().getHelpMan().get(term);
        if (help != null) {
            this.getMain().getConsole().help(sender, help.getCommand(), help.getDescription(), help.getUsages(), help.getAliases());
            return true;
        }
        Map<Integer, List<Help>> helpPages = this.getMain().getHelpMan().getPages(term);
        if (pageNumber == 0) {
            pageNumber = 1;
        }
        if (helpPages.containsKey(pageNumber - 1)) {
            this.showPage(sender, pageNumber, helpPages.size(), term, helpPages.get(pageNumber - 1));
            return true;
        }
        if (helpPages.size() <= pageNumber - 1) {
            this.showPage(sender, helpPages.size(), helpPages.size(), term, helpPages.get(helpPages.size() - 1));
            return true;
        }
        this.showPage(sender, 1, helpPages.size(), term, helpPages.get(0));
        return true;
    }

    public void showPage(Player sender, int pageNumber, int maxPages, String term, List<Help> help) {
        String title = LangEntry.HELP_Header.get(this.getMain());
        String pageNumberString = String.format("%s%s%s", ChatColor.AQUA, pageNumber, ChatColor.GREEN);
        String maxPagesString = String.format("%s%s%s", ChatColor.AQUA, maxPages, ChatColor.GREEN);
        if (term.isEmpty()) {
            this.getMain().getConsole().info(sender, title, ChatColor.GREEN, pageNumberString, maxPagesString, ChatColor.GREEN);
        } else {
            String termString = String.format("%s'%s'%s", ChatColor.AQUA, term, ChatColor.GREEN);
            this.getMain().getConsole().info(sender, title, ChatColor.GREEN, pageNumberString, maxPagesString, termString);
        }
        this.getMain().getConsole().info(sender, "", new Object[0]);
        if (help.isEmpty()) {
            this.getMain().getConsole().info(sender, LangEntry.HELP_NoneFound.get(this.getMain()), new Object[0]);
            return;
        }
        for (Help helpCom : help) {
            this.getMain().getConsole().info(sender, "%s%s%s: %s%s", ChatColor.AQUA, helpCom.getCommand(), ChatColor.WHITE, ChatColor.GREEN, helpCom.getDescription(64));
        }
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return this.onPlayerCommand(null, args);
    }
}

