/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.mail;

import java.util.Map;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.mail.Mail;
import org.divinitycraft.divinityeconomy.mail.MailList;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class ReadMail
extends DivinityCommand {
    public ReadMail(DEPlugin app) {
        super(app, "readmail", false, Setting.COMMAND_READ_MAIL_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        int page;
        if (!this.getMain().getMailMan().isMailEnabled()) {
            this.returnCommandDisabled(sender);
            return true;
        }
        int pageSize = 10;
        switch (args.length) {
            case 0: {
                page = 0;
                break;
            }
            case 1: {
                page = Converter.getInt(args[0]) - 1;
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (page < 0) {
            this.getMain().getConsole().usage(sender, LangEntry.MAIL_InvalidPage.get(this.getMain()), this.help.getUsages());
        } else {
            MailList mailList = this.getMain().getMailMan().getMailList(sender.getUniqueId().toString());
            if (mailList.getAllMail().isEmpty()) {
                this.getMain().getConsole().warn(sender, LangEntry.MAIL_YouHaveNoMail.get(this.getMain()), new Object[0]);
            } else {
                Map<Integer, Mail[]> mailPages = mailList.getPages(pageSize);
                if (page + 1 > mailPages.size()) {
                    this.getMain().getConsole().warn(sender, LangEntry.MAIL_InvalidPageChoose.get(this.getMain()), mailPages.size());
                } else {
                    Mail[] mailPage = mailPages.get(page);
                    this.getMain().getConsole().info(sender, LangEntry.MAIL_List.get(this.getMain()), page + 1, mailPages.size());
                    int idx = 1;
                    for (Mail mail : mailPage) {
                        if (mail == null) break;
                        this.getMain().getConsole().info(sender, "%s: %s", idx, mail.getMessage());
                        mail.setRead(true);
                        ++idx;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

