/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.market;

import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandMaterials;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialManager;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialValueResponse;
import org.divinitycraft.divinityeconomy.player.PlayerManager;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class Buy
extends DivinityCommandMaterials {
    public Buy(DEPlugin app) {
        super(app, "buy", false, Setting.COMMAND_BUY_ITEM_ENABLE_BOOLEAN);
        this.checkItemMarketEnabled = true;
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        MarketableMaterial marketableMaterial;
        String materialName;
        int amountToBuy = 1;
        switch (args.length) {
            case 1: {
                materialName = args[0];
                break;
            }
            case 2: {
                materialName = args[0];
                if (LangEntry.W_max.is(this.getMain(), args[1])) {
                    marketableMaterial = this.getMain().getMarkMan().getItem(materialName);
                    if (marketableMaterial != null) {
                        amountToBuy = marketableMaterial.getAvailableSpace(sender);
                        break;
                    }
                    amountToBuy = 0;
                    break;
                }
                amountToBuy = Converter.getInt(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (amountToBuy > 10000 || amountToBuy < 1) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidAmountGiven.logLevel, LangEntry.GENERIC_InvalidAmountGiven.get(this.getMain()), new Object[0]);
            return true;
        }
        marketableMaterial = this.getMain().getMarkMan().getItem(materialName);
        if (marketableMaterial == null) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidItemName.logLevel, LangEntry.MARKET_InvalidItemName.get(this.getMain()), materialName);
            return true;
        }
        MaterialManager manager = marketableMaterial.getManager();
        if (!marketableMaterial.getAllowed()) {
            this.getMain().getConsole().logFailedPurchase((OfflinePlayer)sender, amountToBuy, marketableMaterial.getName(), LangEntry.MARKET_ItemIsBanned.get(this.getMain(), marketableMaterial.getName()));
            return true;
        }
        int availableSpace = marketableMaterial.getAvailableSpace(sender);
        if (amountToBuy > availableSpace) {
            this.getMain().getConsole().logFailedPurchase((OfflinePlayer)sender, amountToBuy, marketableMaterial.getName(), String.format(LangEntry.MARKET_InvalidInventorySpace.get(this.getMain()), availableSpace, amountToBuy));
            return true;
        }
        if (!marketableMaterial.has(amountToBuy)) {
            this.getMain().getConsole().logFailedPurchase((OfflinePlayer)sender, amountToBuy, marketableMaterial.getName(), String.format(LangEntry.MARKET_InvalidStockAmount.get(this.getMain()), marketableMaterial.getQuantity(), amountToBuy));
            return true;
        }
        MaterialValueResponse priceResponse = manager.getBuyValue(marketableMaterial.getItemStacks(amountToBuy));
        EconomyResponse saleResponse = this.getMain().getEconMan().remCash((OfflinePlayer)sender, priceResponse.getValue());
        if (!saleResponse.transactionSuccess() || priceResponse.isFailure()) {
            String errorMessage = LangEntry.GENERIC_UnknownError.get(this.getMain());
            if (!saleResponse.transactionSuccess()) {
                errorMessage = saleResponse.errorMessage;
            } else if (priceResponse.isFailure()) {
                errorMessage = priceResponse.getErrorMessage();
            }
            this.getMain().getConsole().logFailedPurchase((OfflinePlayer)sender, priceResponse.getQuantity(), marketableMaterial.getName(), errorMessage);
            return true;
        }
        PlayerManager.addPlayerItems(sender, priceResponse.getItemStacksAsArray());
        manager.editQuantity(marketableMaterial, -priceResponse.getQuantity());
        this.getMain().getConsole().logPurchase((OfflinePlayer)sender, priceResponse.getQuantity(), saleResponse.amount, marketableMaterial.getName());
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

