/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.market;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandMaterialsTC;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class BuyTC
extends DivinityCommandMaterialsTC {
    public BuyTC(DEPlugin app) {
        super(app, "buy", false, Setting.COMMAND_BUY_ITEM_ENABLE_BOOLEAN);
    }

    @Override
    public List<String> onPlayerTabCompleter(Player sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        return Arrays.asList(switch (args.length) {
            case 1 -> this.getMain().getMarkMan().getItemNames(args[0]).toArray(new String[0]);
            case 2 -> {
                MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(args[0]);
                if (marketableMaterial != null) {
                    int stackSize = marketableMaterial.getMaterial().getMaxStackSize();
                    list.add(String.valueOf(stackSize));
                    LangEntry.W_max.addLang(this.getMain(), list);
                    list.add(String.valueOf(marketableMaterial.getAvailableSpace(sender)));
                    yield list.toArray(new String[0]);
                }
                LangEntry.MARKET_UnknownMaterial.addLang(this.getMain(), list);
                yield list.toArray(new String[0]);
            }
            case 3 -> {
                MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(args[0]);
                String value = LangEntry.W_unknown.get(this.getMain());
                if (marketableMaterial != null) {
                    int amount = LangEntry.W_max.is(this.getMain(), args[1]) ? marketableMaterial.getAvailableSpace(sender) : Converter.getInt(args[1]);
                    amount = Converter.constrainInt(amount, 1, 10000);
                    args[1] = String.valueOf(amount);
                    value = String.format("%s", this.getMain().getConsole().formatMoney(marketableMaterial.getManager().calculatePrice(amount, marketableMaterial.getQuantity(), marketableMaterial.getManager().getBuyScale(), true)));
                }
                yield new String[]{LangEntry.VALUE_Response.get(this.getMain(), value)};
            }
            default -> new String[]{};
        });
    }

    @Override
    public List<String> onConsoleTabCompleter(String[] args) {
        return null;
    }
}

