/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.market;

import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandMaterials;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialValueResponse;
import org.divinitycraft.divinityeconomy.player.PlayerManager;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class HandBuy
extends DivinityCommandMaterials {
    public HandBuy(DEPlugin app) {
        super(app, "handbuy", false, Setting.COMMAND_HAND_BUY_ITEM_ENABLE_BOOLEAN);
        this.checkItemMarketEnabled = true;
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        int amountToBuy;
        switch (args.length) {
            case 0: {
                amountToBuy = 1;
                break;
            }
            case 1: {
                amountToBuy = Converter.getInt(args[0]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (amountToBuy > 10000 || amountToBuy < 1) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidAmountGiven.logLevel, LangEntry.GENERIC_InvalidAmountGiven.get(this.getMain()), new Object[0]);
            return true;
        }
        ItemStack heldItem = PlayerManager.getHeldItem(sender);
        if (heldItem == null) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidAmountGiven.logLevel, LangEntry.MARKET_InvalidItemHeld.get(this.getMain()), new Object[0]);
            return true;
        }
        MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(heldItem);
        if (marketableMaterial == null) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidItemHeld.logLevel, LangEntry.MARKET_InvalidItemHeld.get(this.getMain()), new Object[0]);
            return true;
        }
        int availableSpace = marketableMaterial.getAvailableSpace(sender);
        if (!marketableMaterial.getAllowed()) {
            this.getMain().getConsole().logFailedPurchase((OfflinePlayer)sender, amountToBuy, marketableMaterial.getName(), LangEntry.MARKET_ItemIsBanned.get(this.getMain(), marketableMaterial.getName()));
            return true;
        }
        if (amountToBuy > availableSpace) {
            this.getMain().getConsole().logFailedPurchase((OfflinePlayer)sender, amountToBuy, marketableMaterial.getName(), String.format(LangEntry.MARKET_InvalidInventorySpace.get(this.getMain()), availableSpace, amountToBuy));
            return true;
        }
        if (!marketableMaterial.has(amountToBuy)) {
            this.getMain().getConsole().logFailedPurchase((OfflinePlayer)sender, amountToBuy, marketableMaterial.getName(), String.format(LangEntry.MARKET_InvalidStockAmount.get(this.getMain()), marketableMaterial.getQuantity(), amountToBuy));
            return true;
        }
        MaterialValueResponse priceResponse = marketableMaterial.getManager().getBuyValue(marketableMaterial.getItemStacks(amountToBuy));
        EconomyResponse saleResponse = this.getMain().getEconMan().remCash((OfflinePlayer)sender, priceResponse.getValue());
        if (saleResponse.transactionSuccess() && priceResponse.isSuccess()) {
            PlayerManager.addPlayerItems(sender, priceResponse.getItemStacksAsArray());
            marketableMaterial.getManager().editQuantity(marketableMaterial, -priceResponse.getQuantity());
            this.getMain().getConsole().logPurchase((OfflinePlayer)sender, priceResponse.getQuantity(), saleResponse.amount, marketableMaterial.getName());
        } else {
            String errorMessage = LangEntry.GENERIC_UnknownError.get(this.getMain());
            if (!saleResponse.transactionSuccess()) {
                errorMessage = saleResponse.errorMessage;
            } else if (priceResponse.isFailure()) {
                errorMessage = priceResponse.getErrorMessage();
            }
            this.getMain().getConsole().logFailedPurchase((OfflinePlayer)sender, priceResponse.getQuantity(), marketableMaterial.getName(), errorMessage);
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

