/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.market;

import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandMaterials;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.MarketableToken;
import org.divinitycraft.divinityeconomy.market.items.ItemManager;
import org.divinitycraft.divinityeconomy.market.items.enchants.EnchantValueResponse;
import org.divinitycraft.divinityeconomy.market.items.enchants.MarketableEnchant;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialValueResponse;
import org.divinitycraft.divinityeconomy.player.PlayerManager;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class HandValue
extends DivinityCommandMaterials {
    public HandValue(DEPlugin app) {
        super(app, "handvalue", false, Setting.COMMAND_HAND_VALUE_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        EnchantValueResponse evr;
        ItemStack[] sellStacks;
        ItemStack[] buyStacks;
        int amount = 1;
        boolean valueAll = false;
        boolean valueHand = false;
        switch (args.length) {
            case 0: {
                valueHand = true;
                break;
            }
            case 1: {
                String firstArg = args[0].toLowerCase();
                if (LangEntry.W_max.is(this.getMain(), firstArg)) {
                    valueAll = true;
                    break;
                }
                amount = Converter.getInt(firstArg);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (amount > 10000 || amount < 1) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidAmountGiven.logLevel, LangEntry.GENERIC_InvalidAmountGiven.get(this.getMain()), new Object[0]);
            return true;
        }
        ItemStack heldItem = PlayerManager.getHeldItem(sender);
        if (heldItem == null) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidItemHeld.logLevel, LangEntry.MARKET_InvalidItemHeld.get(this.getMain()), new Object[0]);
            return true;
        }
        MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(heldItem);
        if (marketableMaterial == null) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidItemHeld.logLevel, LangEntry.MARKET_InvalidItemHeld.get(this.getMain()), new Object[0]);
            return true;
        }
        ItemStack[] itemStacks = marketableMaterial.getMaterialSlots(sender);
        if (valueHand) {
            amount = heldItem.getAmount();
            buyStacks = marketableMaterial.getItemStacks(amount);
            sellStacks = new ItemStack[]{heldItem};
        } else if (valueAll) {
            amount = ItemManager.getMaterialCount(itemStacks);
            sellStacks = itemStacks;
            buyStacks = marketableMaterial.getItemStacks(amount);
        } else {
            buyStacks = sellStacks = marketableMaterial.getItemStacks(amount);
        }
        MaterialValueResponse buyResponse = marketableMaterial.getManager().getBuyValue(buyStacks);
        MaterialValueResponse sellResponse = marketableMaterial.getManager().getSellValue(sellStacks);
        buyResponse.cleanup();
        sellResponse.cleanup();
        if (buyResponse.isSuccess()) {
            this.getMain().getConsole().info(sender, LangEntry.VALUE_BuyResponse.get(this.getMain()), amount, marketableMaterial.getName(), this.getMain().getConsole().formatMoney(buyResponse.getValue()));
            evr = this.getMain().getEnchMan().getBuyValue(heldItem, 0);
            if (evr.isSuccess() && evr.getQuantity() > 0) {
                this.getMain().getConsole().info(sender, LangEntry.PURCHASE_ValueEnchantSummary.get(this.getMain()), evr.getQuantity(), this.getMain().getConsole().formatMoney(evr.getValue()));
                for (MarketableToken token1 : evr.getTokens()) {
                    MarketableEnchant enchant1 = (MarketableEnchant)token1;
                    if (enchant1.getQuantity() == 0) continue;
                    this.getMain().getConsole().info(sender, LangEntry.PURCHASE_ValueEnchant.get(this.getMain()), evr.getQuantity(enchant1), enchant1.getName(), this.getMain().getConsole().formatMoney(evr.getValue(enchant1)));
                }
            }
        } else {
            this.getMain().getConsole().info(sender, LangEntry.VALUE_BuyFailedResponse.get(this.getMain()), amount, marketableMaterial.getName(), buyResponse.getErrorMessage());
        }
        if (sellResponse.isSuccess()) {
            this.getMain().getConsole().info(sender, LangEntry.VALUE_SellResponse.get(this.getMain()), amount, marketableMaterial.getName(), this.getMain().getConsole().formatMoney(sellResponse.getValue()));
            evr = this.getMain().getEnchMan().getSellValue(heldItem, 0);
            if (evr.isSuccess() && evr.getQuantity() > 0) {
                this.getMain().getConsole().info(sender, LangEntry.SALE_ValueEnchantSummary.get(this.getMain()), evr.getQuantity(), this.getMain().getConsole().formatMoney(evr.getValue()));
                for (MarketableToken token2 : evr.getTokens()) {
                    MarketableEnchant enchant2 = (MarketableEnchant)token2;
                    if (enchant2.getQuantity() == 0) continue;
                    this.getMain().getConsole().info(sender, LangEntry.SALE_ValueEnchant.get(this.getMain()), evr.getQuantity(enchant2), enchant2.getName(), this.getMain().getConsole().formatMoney(evr.getValue(enchant2)));
                }
            }
        } else {
            this.getMain().getConsole().info(sender, LangEntry.VALUE_SellFailedResponse.get(this.getMain()), amount, marketableMaterial.getName(), sellResponse.getErrorMessage());
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

