/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.market;

import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandMaterials;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialValueResponse;
import org.divinitycraft.divinityeconomy.player.PlayerManager;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class Sell
extends DivinityCommandMaterials {
    public Sell(DEPlugin app) {
        super(app, "sell", false, Setting.COMMAND_SELL_ITEM_ENABLE_BOOLEAN);
        this.checkItemMarketEnabled = true;
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        String materialName;
        int amountToSell = 1;
        boolean sellAll = false;
        switch (args.length) {
            case 1: {
                materialName = args[0];
                break;
            }
            case 2: {
                materialName = args[0];
                String arg = args[1];
                if (LangEntry.W_max.is(this.getMain(), arg)) {
                    sellAll = true;
                    break;
                }
                amountToSell = Converter.getInt(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (amountToSell > 10000 || amountToSell < 1) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidAmountGiven.logLevel, LangEntry.GENERIC_InvalidAmountGiven.get(this.getMain()), new Object[0]);
            return true;
        }
        MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(materialName);
        if (marketableMaterial == null) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidItemName.logLevel, LangEntry.MARKET_InvalidItemName.get(this.getMain()), materialName);
            return true;
        }
        int materialCount = marketableMaterial.getMaterialCount(sender);
        if (sellAll) {
            amountToSell = materialCount;
        }
        if (!marketableMaterial.getAllowed()) {
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, amountToSell, marketableMaterial.getName(), LangEntry.MARKET_ItemIsBanned.get(this.getMain(), marketableMaterial.getName()));
            return true;
        }
        if (materialCount < amountToSell) {
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, amountToSell, marketableMaterial.getName(), String.format(LangEntry.MARKET_InvalidInventoryStock.get(this.getMain()), materialCount, amountToSell));
            return true;
        }
        ItemStack[] allStacks = marketableMaterial.getMaterialSlotsToCount(sender, amountToSell);
        MaterialValueResponse response = marketableMaterial.getManager().getSellValue(allStacks);
        if (response.getItemStacks().size() == 0) {
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, response.getQuantity(), marketableMaterial.getName(), LangEntry.MARKET_NothingToSellAfterSkipping.get(this.getMain()).toLowerCase());
            return true;
        }
        if (response.isFailure()) {
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, response.getQuantity(), marketableMaterial.getName(), response.getErrorMessage());
            return true;
        }
        PlayerManager.removePlayerItems(response.getItemStacksAsArray());
        EconomyResponse economyResponse = this.getMain().getEconMan().addCash((OfflinePlayer)sender, response.getValue());
        if (!economyResponse.transactionSuccess()) {
            PlayerManager.addPlayerItems(sender, response.getClonesAsArray());
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, response.getQuantity(), marketableMaterial.getName(), economyResponse.errorMessage);
        } else {
            marketableMaterial.getManager().editQuantity(marketableMaterial, response.getQuantity());
            this.getMain().getConsole().logSale((OfflinePlayer)sender, response.getQuantity(), response.getValue(), marketableMaterial.getName());
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

