/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.market;

import java.util.ArrayList;
import java.util.HashSet;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandMaterials;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.MarketableToken;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialValueResponse;
import org.divinitycraft.divinityeconomy.player.PlayerManager;

public class SellAll
extends DivinityCommandMaterials {
    public SellAll(DEPlugin app) {
        super(app, "sellall", false, Setting.COMMAND_SELLALL_ITEM_ENABLE_BOOLEAN);
        this.checkItemMarketEnabled = true;
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        boolean blocking = false;
        HashSet<MarketableMaterial> marketableMaterials = new HashSet<MarketableMaterial>();
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                String arg = args[0];
                if (arg.startsWith("!")) {
                    blocking = true;
                    arg = arg.replaceFirst("!", "");
                }
                for (String materialName : arg.split(",")) {
                    MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(materialName);
                    if (marketableMaterial == null) {
                        this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidItemName.logLevel, LangEntry.MARKET_InvalidItemName.get(this.getMain()), materialName);
                        return true;
                    }
                    marketableMaterials.add(marketableMaterial);
                }
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        ItemStack[] playerInventory = PlayerManager.getInventoryMaterials(sender);
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        for (ItemStack itemStack : playerInventory) {
            MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(itemStack);
            if (!(blocking && !marketableMaterials.contains(marketableMaterial) || !blocking && marketableMaterials.contains(marketableMaterial)) && (blocking || marketableMaterials.size() != 0)) continue;
            itemStackList.add(itemStack);
        }
        ItemStack[] allStacks = itemStackList.toArray(new ItemStack[0]);
        if (allStacks.length == 0) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_NothingToSell.logLevel, LangEntry.MARKET_NothingToSell.get(this.getMain()), new Object[0]);
            return true;
        }
        MaterialValueResponse response = this.getMain().getMarkMan().getSellValue(allStacks);
        if (response.getTokenIds().size() == 0) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_NothingToSellAfterSkipping.logLevel, LangEntry.MARKET_NothingToSellAfterSkipping.get(this.getMain()), new Object[0]);
            return true;
        }
        if (!response.isSuccess()) {
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, response.getQuantity(), LangEntry.W_items.get(this.getMain()), response.getErrorMessage());
            return true;
        }
        PlayerManager.removePlayerItems(response.getItemStacksAsArray());
        EconomyResponse economyResponse = this.getMain().getEconMan().addCash((OfflinePlayer)sender, response.getValue());
        if (!economyResponse.transactionSuccess()) {
            PlayerManager.addPlayerItems(sender, response.getClonesAsArray());
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, response.getQuantity(), LangEntry.W_items.get(this.getMain()), economyResponse.errorMessage);
            return true;
        }
        for (MarketableToken token : response.getQuantities().keySet()) {
            MarketableMaterial material = (MarketableMaterial)token;
            material.getManager().editQuantity(material, response.getQuantity(material));
        }
        this.getMain().getConsole().logSale((OfflinePlayer)sender, response.getQuantity(), response.getValue(), LangEntry.W_items.get(this.getMain()));
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

