/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.market;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandMaterialsTC;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.player.PlayerManager;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class SellTC
extends DivinityCommandMaterialsTC {
    public SellTC(DEPlugin app) {
        super(app, "sell", false, Setting.COMMAND_SELL_ITEM_ENABLE_BOOLEAN);
    }

    @Override
    public List<String> onPlayerTabCompleter(Player sender, String[] args) {
        return Arrays.asList(switch (args.length) {
            case 1 -> this.getMain().getMarkMan().getItemNames(PlayerManager.getInventoryMaterialNames(sender), args[0]).toArray(new String[0]);
            case 2 -> {
                MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(args[0]);
                if (marketableMaterial == null) {
                    yield new String[]{LangEntry.MARKET_InvalidMaterialName.get(this.getMain())};
                }
                Material material = marketableMaterial.getMaterial();
                ArrayList<String> allStrings = new ArrayList<String>();
                LangEntry.W_max.addLang(this.getMain(), allStrings);
                int stackSize = material.getMaxStackSize();
                int inventoryCount = marketableMaterial.getMaterialCount(sender);
                if (stackSize < inventoryCount) {
                    allStrings.add(String.valueOf(stackSize));
                }
                allStrings.add(String.valueOf(inventoryCount));
                yield allStrings.toArray(new String[0]);
            }
            case 3 -> {
                MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(args[0]);
                String value = LangEntry.W_unknown.get(this.getMain());
                if (marketableMaterial != null) {
                    int amount = LangEntry.W_max.is(this.getMain(), args[1]) ? marketableMaterial.getAvailableSpace(sender) : Converter.getInt(args[1]);
                    amount = Converter.constrainInt(amount, 1, 10000);
                    args[1] = String.valueOf(amount);
                    value = this.getMain().getConsole().formatMoney(marketableMaterial.getManager().getSellValue(marketableMaterial.getMaterialSlotsToCount(sender, amount)).getValue());
                }
                yield new String[]{LangEntry.VALUE_Response.get(this.getMain(), value)};
            }
            default -> new String[]{};
        });
    }

    @Override
    public List<String> onConsoleTabCompleter(String[] args) {
        return null;
    }
}

