/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.market;

import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandMaterials;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialValueResponse;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class Value
extends DivinityCommandMaterials {
    public Value(DEPlugin app) {
        super(app, "value", true, Setting.COMMAND_VALUE_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        String materialName;
        int amount = 1;
        switch (args.length) {
            case 1: {
                materialName = args[0];
                break;
            }
            case 2: {
                materialName = args[0];
                amount = Converter.getInt(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (amount > 10000 || amount < 1) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidAmountGiven.logLevel, LangEntry.GENERIC_InvalidAmountGiven.get(this.getMain()), new Object[0]);
            return true;
        }
        MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(materialName);
        if (marketableMaterial == null) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidItemName.logLevel, LangEntry.MARKET_InvalidItemName.get(this.getMain()), materialName);
            return true;
        }
        ItemStack[] itemStacks = marketableMaterial.getItemStacks(amount);
        MaterialValueResponse buyResponse = marketableMaterial.getManager().getBuyValue(itemStacks);
        MaterialValueResponse sellResponse = marketableMaterial.getManager().getSellValue(itemStacks);
        buyResponse.cleanup();
        sellResponse.cleanup();
        if (buyResponse.isSuccess()) {
            this.getMain().getConsole().info(sender, LangEntry.VALUE_BuyResponse.get(this.getMain()), amount, marketableMaterial.getName(), this.getMain().getConsole().formatMoney(buyResponse.getValue()));
        } else {
            this.getMain().getConsole().info(sender, LangEntry.VALUE_BuyFailedResponse.get(this.getMain()), amount, marketableMaterial.getName(), buyResponse.getErrorMessage());
        }
        if (sellResponse.isSuccess()) {
            this.getMain().getConsole().info(sender, LangEntry.VALUE_SellResponse.get(this.getMain()), amount, marketableMaterial.getName(), this.getMain().getConsole().formatMoney(sellResponse.getValue()));
        } else {
            this.getMain().getConsole().info(sender, LangEntry.VALUE_SellFailedResponse.get(this.getMain()), amount, marketableMaterial.getName(), sellResponse.getErrorMessage());
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return this.onPlayerCommand(null, args);
    }
}

