/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.money;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;

public class Balance
extends DivinityCommand {
    protected final boolean isBalanceEnabled;
    protected final boolean isBalanceOtherEnabled;
    private final String balancePermission = "de.money.balance";
    private final String balanceOtherPermission = "de.money.balanceOther";

    public Balance(DEPlugin app) {
        super(app, "balance", true, true);
        this.checkEconomyEnabled = true;
        this.checkPermissions = false;
        this.isBalanceEnabled = this.getMain().getConfMan().getBoolean(Setting.COMMAND_BALANCE_ENABLE_BOOLEAN);
        this.isBalanceOtherEnabled = this.getMain().getConfMan().getBoolean(Setting.COMMAND_BALANCE_OTHER_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        Player receiverPlayer;
        if (args.length == 1) {
            if (!this.isBalanceOtherEnabled) {
                this.returnCommandDisabled(sender);
                return true;
            }
            if (!sender.hasPermission("de.money.balanceOther")) {
                this.returnPlayerNoPermission(sender);
                return true;
            }
            receiverPlayer = this.getMain().getPlayMan().getPlayer(args[0], false);
        } else {
            if (!this.isBalanceEnabled) {
                this.returnCommandDisabled(sender);
                return true;
            }
            if (!sender.hasPermission("de.money.balance")) {
                this.returnPlayerNoPermission(sender);
                return true;
            }
            receiverPlayer = sender;
        }
        if (receiverPlayer == null) {
            this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidPlayerName.get(this.getMain()), this.help.getUsages());
            return true;
        }
        this.getMain().getConsole().send(sender, LangEntry.BALANCE_ResponseOther.logLevel, LangEntry.BALANCE_ResponseOther.get(this.getMain()), receiverPlayer.getName(), this.getMain().getConsole().getFormattedBalance((OfflinePlayer)receiverPlayer));
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        if (args.length == 1) {
            if (!this.isBalanceOtherEnabled) {
                this.returnCommandDisabled(null);
                return true;
            }
        } else {
            if (!this.isBalanceEnabled) {
                this.returnCommandDisabled(null);
                return true;
            }
            this.getMain().getConsole().usage(LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
            return true;
        }
        OfflinePlayer player = this.getMain().getPlayMan().getPlayer(args[0], false);
        if (player == null) {
            this.getMain().getConsole().send(LangEntry.GENERIC_InvalidPlayerName.logLevel, LangEntry.GENERIC_InvalidPlayerName.get(this.getMain()), new Object[0]);
            return true;
        }
        this.getMain().getConsole().send(LangEntry.BALANCE_ResponseOther.logLevel, LangEntry.BALANCE_ResponseOther.get(this.getMain()), player.getName(), this.getMain().getConsole().getFormattedBalance(player));
        return true;
    }
}

