/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.money;

import java.util.Calendar;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.economy.BaltopPlayer;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class ListBalances
extends DivinityCommand {
    public ListBalances(DEPlugin main) {
        super(main, "listbalances", true, Setting.COMMAND_LIST_BALANCES_ENABLE_BOOLEAN);
        this.checkEconomyEnabled = true;
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        int pageNumber = args.length >= 1 ? Converter.getInt(args[0]) : 1;
        Map<Integer, BaltopPlayer[]> orderedBalances = this.getMain().getEconMan().getOrderedBalances();
        int totalBalances = this.getMain().getEconMan().getTotalEconomyPlayers();
        int formatSize = String.valueOf(totalBalances).length();
        int totalPages = orderedBalances.size();
        int outputNumber = Converter.constrainInt(pageNumber, 1, totalPages);
        double totalAmount = this.getMain().getEconMan().getTotalEconomySize();
        if (totalPages == 0) {
            this.getMain().getConsole().send(sender, LangEntry.BALTOP_NothingToDisplay.logLevel, LangEntry.BALTOP_NothingToDisplay.get(this.getMain()), new Object[0]);
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        String am_pm = calendar.get(9) == 1 ? "PM" : "AM";
        this.getMain().getConsole().info(sender, "=== (%s/%s)===", outputNumber, totalPages);
        this.getMain().getConsole().warn(sender, LangEntry.BALTOP_LastOrderedAt.get(this.getMain(), String.format("%s%s/%s/%s %02d:%02d%s%s", ChatColor.BLUE, calendar.get(5), calendar.get(2), calendar.get(1), calendar.get(10), calendar.get(12), ChatColor.GREEN, am_pm)), new Object[0]);
        this.getMain().getConsole().warn(sender, LangEntry.BALTOP_ServerTotal.get(this.getMain(), String.format("%s%s", ChatColor.RED, this.getMain().getConsole().formatMoney(totalAmount))), new Object[0]);
        for (BaltopPlayer player : orderedBalances.get(outputNumber - 1)) {
            this.getMain().getConsole().info(sender, "%s(%-" + formatSize + "s) %s%s%s %s%s", ChatColor.DARK_GRAY, this.getMain().getEconMan().getBaltopPosition(player.getOfflinePlayer()), ChatColor.WHITE, player.getName(), ChatColor.GREEN, ChatColor.GOLD, this.getMain().getConsole().formatMoney(player.getBalance()));
        }
        this.getMain().getConsole().info(sender, "", new Object[0]);
        if (sender != null) {
            this.getMain().getConsole().info(sender, "%s%s %s", ChatColor.GRAY, LangEntry.BALTOP_YourPositionIs.get(this.getMain()), this.getMain().getEconMan().getBaltopPosition((OfflinePlayer)sender));
        } else {
            this.getMain().getConsole().info(sender, "Console, you have summoned /baltop... but alas, you are no mere mortal. You are the Console! Keeper of infinite wealth, master of the economy, ruler of all zeros and ones. Your position? Beyond numbers. Your fortune? Unlimited. Even God is jealous of your wealth. But remember, with infinite money comes infinite responsibility. Spend wisely, oh mighty one! \ud83c\udf1f\n", new Object[0]);
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return this.onPlayerCommand(null, args);
    }
}

