/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.money;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.response.EconomyTransferResponse;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class SendCash
extends DivinityCommand {
    public SendCash(DEPlugin app) {
        super(app, "sendcash", false, Setting.COMMAND_SEND_CASH_ENABLE_BOOLEAN);
        this.checkEconomyEnabled = true;
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        double amount;
        OfflinePlayer player2;
        switch (args.length) {
            case 2: {
                player2 = this.getMain().getPlayMan().getPlayer(args[0], false);
                amount = Converter.getDouble(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (player2 == null) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidPlayerName.logLevel, LangEntry.GENERIC_InvalidPlayerName.get(this.getMain()), new Object[0]);
            return true;
        }
        EconomyTransferResponse response = this.getMain().getEconMan().sendCash((OfflinePlayer)sender, player2, amount);
        if (response.isSuccess()) {
            this.getMain().getConsole().logTransfer((OfflinePlayer)sender, player2, amount);
        } else {
            this.getMain().getConsole().logFailedTransfer((OfflinePlayer)sender, player2, amount, response.getErrorMessage());
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

