/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.config;

import com.tchristofferson.configupdater.ConfigUpdater;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.DivinityModule;
import org.divinitycraft.divinityeconomy.config.Setting;

public class ConfigManager
extends DivinityModule {
    public static final String configFile = "config.yml";
    private String loadedVersion;

    public ConfigManager(DEPlugin main) {
        super(main);
        this.getMain().saveDefaultConfig();
    }

    @Override
    public void init() {
        FileConfiguration config = this.getMain().getConfig();
        this.loadedVersion = config.getString(Setting.MAIN_VERSION_STRING.path);
        String pluginVersion = config.getDefaults().getString(Setting.MAIN_VERSION_STRING.path);
        this.getConsole().info("Detected config versions local/plugin | %s/%s", this.loadedVersion, pluginVersion);
        config.set(Setting.MAIN_VERSION_STRING.path, (Object)pluginVersion);
        this.saveFile(config, configFile);
        try {
            ConfigUpdater.update((Plugin)this.getMain(), configFile, this.getFile(configFile), Collections.emptyList());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getMain().reloadConfig();
    }

    @Override
    public void deinit() {
    }

    public Object get(Setting setting) {
        return this.getMain().getConfig().get(setting.path, this.getMain().getConfig().getDefaults().get(setting.path));
    }

    public Integer getInt(Setting setting) {
        return this.getMain().getConfig().getInt(setting.path, this.getMain().getConfig().getDefaults().getInt(setting.path));
    }

    public Boolean getBoolean(Setting setting) {
        return this.getMain().getConfig().getBoolean(setting.path, this.getMain().getConfig().getDefaults().getBoolean(setting.path));
    }

    public Double getDouble(Setting setting) {
        return this.getMain().getConfig().getDouble(setting.path, this.getMain().getConfig().getDefaults().getDouble(setting.path));
    }

    public String getString(Setting setting) {
        return this.getMain().getConfig().getString(setting.path, this.getMain().getConfig().getDefaults().getString(setting.path));
    }

    public List<String> getStringList(Setting setting) {
        return this.getMain().getConfig().getStringList(setting.path);
    }

    public void set(Setting setting, Object value) {
        this.getMain().getConfig().set(setting.path, value);
    }

    public File getFile(String file) {
        return new File(this.getMain().getDataFolder(), file);
    }

    public File getFile(File folder, String file) {
        return new File(folder, file);
    }

    public File getFolder(String folder) {
        File newFolder = new File(this.getMain().getDataFolder(), folder);
        if (!newFolder.exists()) {
            if (newFolder.mkdir()) {
                return newFolder;
            }
            return null;
        }
        if (newFolder.isDirectory()) {
            return newFolder;
        }
        return null;
    }

    public List<File> getFolderFiles(String folder) {
        File newFolder = this.getFolder(folder);
        if (newFolder != null) {
            return Arrays.asList(this.getFolder(folder).listFiles());
        }
        return Collections.emptyList();
    }

    public FileConfiguration readResource(String file) {
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getMain().getResource(file)));
    }

    public FileConfiguration readFile(String file) {
        return this.readFile(this.getFile(file));
    }

    public FileConfiguration readFile(File file) {
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public FileConfiguration loadFile(String file) {
        FileConfiguration defConfig = this.readResource(file);
        FileConfiguration config = this.readFile(file);
        if (config.getValues(false).size() == 0) {
            config.setDefaults((Configuration)defConfig);
            config.options().copyDefaults(true);
            this.saveFile(config, file);
        }
        return config;
    }

    public void saveFile(FileConfiguration file, String fileName) {
        try {
            file.save(new File(this.getMain().getDataFolder(), fileName));
        }
        catch (Exception e) {
            this.getConsole().severe("Failed to save file %s", fileName);
        }
    }

    public String getLoadedVersion() {
        return this.loadedVersion;
    }
}

