/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.economy;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.scheduler.BukkitRunnable;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.DivinityModule;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.economy.BaltopPlayer;
import org.divinitycraft.divinityeconomy.economy.DivinityEconomy;
import org.divinitycraft.divinityeconomy.economy.players.EconomyPlayer;
import org.divinitycraft.divinityeconomy.response.EconomyTransferResponse;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class EconomyManager
extends DivinityModule {
    private static final int BALTOP_PAGE_SIZE = 10;
    private Map<Integer, BaltopPlayer[]> orderedBalances = new ConcurrentHashMap<Integer, BaltopPlayer[]>();
    private Map<OfflinePlayer, Integer> baltopPositionCache = new ConcurrentHashMap<OfflinePlayer, Integer>();
    private final Calendar lastOrderTime = Calendar.getInstance();
    private double totalEconomySize = 0.0;
    private int totalEconomyPlayers = 0;
    private final BukkitRunnable baltopTask = new BukkitRunnable(){

        public void run() {
            try {
                EconomyManager.this.fetchBaltop();
            }
            catch (Exception e) {
                EconomyManager.this.getConsole().warn("Failed to fetch baltop (This is likely an issue with your economy provider): %s", e.getMessage());
            }
        }
    };
    public double minTransfer;
    public double minBalance;
    private DivinityEconomy divinityEconomy;
    private Economy economy;

    public EconomyManager(DEPlugin main) {
        super(main, false);
    }

    @Override
    public void init() {
        this.minTransfer = this.getConfMan().getDouble(Setting.ECONOMY_MIN_SEND_AMOUNT_DOUBLE);
        this.minBalance = 0.0;
        this.divinityEconomy = new DivinityEconomy(this.getMain());
        this.economy = this.setupEconomy(this.divinityEconomy);
        this.divinityEconomy.startTasks();
        int timer = Converter.getTicks(Converter.constrainInt(this.getMain().getConfMan().getInt(Setting.ECONOMY_BALTOP_REFRESH_INTEGER), 60, 3600));
        this.baltopTask.runTaskTimerAsynchronously((Plugin)this.getMain(), (long)timer, (long)timer);
        try {
            this.fetchBaltop();
        }
        catch (Exception e) {
            this.getConsole().warn("Failed to fetch baltop on startup (This is likely an issue with your economy provider): %s", e.getMessage());
        }
    }

    @Override
    public void deinit() {
        this.baltopTask.cancel();
        this.divinityEconomy.stopTasks();
    }

    public void fetchBaltop() {
        this.getConsole().debug("Fetching baltop...", new Object[0]);
        double totalSize = 0.0;
        ArrayList<BaltopPlayer> players = new ArrayList<BaltopPlayer>();
        for (OfflinePlayer offlinePlayer : this.getMain().getPlayMan().getPlayers()) {
            double balance = this.getBalance(offlinePlayer);
            players.add(new BaltopPlayer(offlinePlayer, balance, this.getMain().getPlayMan().getPlayerName(offlinePlayer)));
            totalSize += balance;
        }
        players.sort((a, b) -> Double.compare(b.getBalance(), a.getBalance()));
        ArrayList pages = new ArrayList();
        pages.add(new ArrayList());
        ConcurrentHashMap<OfflinePlayer, Integer> positionCache = new ConcurrentHashMap<OfflinePlayer, Integer>();
        int position = 1;
        int index = 0;
        for (BaltopPlayer player : players) {
            ((List)pages.get(pages.size() - 1)).add(player);
            positionCache.put(player.getOfflinePlayer(), position);
            if (index == 10) {
                pages.add(new ArrayList());
                index = 0;
            } else {
                ++index;
            }
            ++position;
        }
        ConcurrentHashMap<Integer, BaltopPlayer[]> playersByPage = new ConcurrentHashMap<Integer, BaltopPlayer[]>();
        for (int i = 0; i < pages.size(); ++i) {
            playersByPage.put(i, ((List)pages.get(i)).toArray(new BaltopPlayer[0]));
        }
        this.orderedBalances.clear();
        this.orderedBalances = playersByPage;
        this.baltopPositionCache.clear();
        this.baltopPositionCache = positionCache;
        this.totalEconomySize = totalSize;
        this.totalEconomyPlayers = players.size();
        this.lastOrderTime.setTimeInMillis(System.nanoTime());
        this.getConsole().debug("Baltop fetched %s players.", players.size());
    }

    public EconomyPlayer getPlayer(OfflinePlayer player) {
        return this.divinityEconomy.get(player);
    }

    public Map<OfflinePlayer, Integer> getBaltopPositionCache() {
        return this.baltopPositionCache;
    }

    public int getBaltopPosition(OfflinePlayer player) {
        return this.baltopPositionCache.getOrDefault(player, 0);
    }

    public Calendar getLastOrderTime() {
        return this.lastOrderTime;
    }

    public double getTotalEconomySize() {
        return this.totalEconomySize;
    }

    public int getTotalEconomyPlayers() {
        return this.totalEconomyPlayers;
    }

    public double getEconomySizePerCapita() {
        if (this.totalEconomyPlayers == 0) {
            return 0.0;
        }
        return this.totalEconomySize / (double)this.totalEconomyPlayers;
    }

    public int getEconomyEquality() {
        if (this.totalEconomyPlayers == 0) {
            return 0;
        }
        double average = this.getEconomySizePerCapita();
        double meanDeviation = 0.0;
        double allowedDeviation = average * 0.1;
        for (OfflinePlayer player : this.getMain().getPlayMan().getPlayers()) {
            double balance = this.getBalance(player);
            double deviation = Math.abs(balance - average);
            if (deviation > allowedDeviation) {
                meanDeviation += deviation;
                continue;
            }
            meanDeviation += deviation * 0.5;
        }
        double maxDeviation = average * (double)this.totalEconomyPlayers;
        double score = 100.0 - meanDeviation / maxDeviation * 100.0;
        return Math.max(0, Math.min(100, (int)score));
    }

    public BaltopPlayer getRichestPlayer() {
        if (this.orderedBalances.isEmpty()) {
            return null;
        }
        return this.orderedBalances.get(0)[0];
    }

    public BaltopPlayer[] getTopPercentile(int percentile) {
        if (this.orderedBalances.isEmpty()) {
            return new BaltopPlayer[0];
        }
        int topPercentile = (int)((double)this.totalEconomyPlayers * ((double)percentile / 100.0));
        ArrayList<BaltopPlayer> topPlayers = new ArrayList<BaltopPlayer>();
        int index = 0;
        for (BaltopPlayer[] players : this.orderedBalances.values()) {
            for (BaltopPlayer player : players) {
                topPlayers.add(player);
                if (++index >= topPercentile) break;
            }
            if (index < topPercentile) continue;
            break;
        }
        return topPlayers.toArray(new BaltopPlayer[0]);
    }

    public BaltopPlayer[] getBottomPercentile(int percentile) {
        if (this.orderedBalances.isEmpty()) {
            return new BaltopPlayer[0];
        }
        int bottomPercentile = (int)((double)this.totalEconomyPlayers * ((double)percentile / 100.0));
        ArrayList<BaltopPlayer> bottomPlayers = new ArrayList<BaltopPlayer>();
        int index = 0;
        for (BaltopPlayer[] players : this.orderedBalances.values()) {
            for (BaltopPlayer player : players) {
                bottomPlayers.add(player);
                if (++index >= bottomPercentile) break;
            }
            if (index < bottomPercentile) continue;
            break;
        }
        return bottomPlayers.toArray(new BaltopPlayer[0]);
    }

    public double getTopPercentileBalance(int percentile) {
        double total = 0.0;
        for (BaltopPlayer player : this.getTopPercentile(percentile)) {
            total += player.getBalance();
        }
        return total;
    }

    public double getBottomPercentileBalance(int percentile) {
        double total = 0.0;
        for (BaltopPlayer player : this.getBottomPercentile(percentile)) {
            total += player.getBalance();
        }
        return total;
    }

    public Map<Integer, BaltopPlayer[]> getOrderedBalances() {
        return this.orderedBalances;
    }

    public void registerProvider(Economy economy) {
        this.getMain().getServer().getServicesManager().register(Economy.class, (Object)economy, (Plugin)this.getMain(), ServicePriority.Normal);
    }

    @Nullable
    public Economy getProvider() {
        return (Economy)this.getMain().getServer().getServicesManager().getRegistration(Economy.class).getProvider();
    }

    @Nullable
    public Economy setupEconomy(DivinityEconomy divinityEconomy) {
        if (this.getMain().getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getConsole().warn("No plugin 'Vault' detected, you must have Vault to use this plugin...", new Object[0]);
            return null;
        }
        this.getConsole().info("Vault detected.", new Object[0]);
        this.registerProvider(divinityEconomy);
        return this.getProvider();
    }

    public Economy getVaultEconomy() {
        return this.economy;
    }

    public double getBalance(OfflinePlayer player) {
        return this.economy.getBalance(player);
    }

    public EconomyResponse addCash(OfflinePlayer oPlayer, double amount) {
        this.getConsole().debug("ADD REQUEST FOR %s %s", oPlayer.getName(), this.getMain().getConsole().formatMoney(amount));
        EconomyResponse response = this.economy.depositPlayer(oPlayer, amount);
        this.getConsole().debug("ADD RESULT: %s %s", response.transactionSuccess(), response.errorMessage);
        return response;
    }

    public EconomyResponse remCash(OfflinePlayer oPlayer, double amount) {
        this.getConsole().debug("REM REQUEST FOR %s %s", oPlayer.getName(), this.getMain().getConsole().formatMoney(amount));
        EconomyResponse response = this.economy.withdrawPlayer(oPlayer, amount);
        this.getConsole().debug("REM RESULT: %s %s", response.transactionSuccess(), response.errorMessage);
        return response;
    }

    public EconomyResponse setCash(OfflinePlayer oPlayer, double amount) {
        this.getConsole().debug("SET REQUEST FOR %s %s", oPlayer.getName(), this.getMain().getConsole().formatMoney(amount));
        double balance = this.getBalance(oPlayer);
        double difference = amount - balance;
        EconomyResponse response = difference < 0.0 ? this.remCash(oPlayer, -difference) : (difference > 0.0 ? this.addCash(oPlayer, difference) : new EconomyResponse(difference, this.getBalance(oPlayer), EconomyResponse.ResponseType.SUCCESS, ""));
        this.getConsole().debug("SET RESULT: %s %s", response.transactionSuccess(), response.errorMessage);
        return response;
    }

    public EconomyTransferResponse sendCash(OfflinePlayer from, OfflinePlayer to, double amount) {
        EconomyTransferResponse response;
        double fromBalance = this.getBalance(from);
        double toBalance = this.getBalance(to);
        if (from == to) {
            response = new EconomyTransferResponse(fromBalance, toBalance, 0.0, EconomyResponse.ResponseType.FAILURE, "cannot send money to yourself!");
        } else if (amount < this.minTransfer) {
            response = new EconomyTransferResponse(fromBalance, toBalance, 0.0, EconomyResponse.ResponseType.FAILURE, String.format("cannot send less than %s", this.getMain().getConsole().formatMoney(this.minTransfer)));
        } else {
            EconomyResponse takeResponse = this.remCash(from, amount);
            if (takeResponse.type == EconomyResponse.ResponseType.FAILURE) {
                response = new EconomyTransferResponse(fromBalance, toBalance, 0.0, EconomyResponse.ResponseType.FAILURE, takeResponse.errorMessage);
            } else {
                EconomyResponse sendResponse = this.addCash(to, amount);
                if (sendResponse.type == EconomyResponse.ResponseType.FAILURE) {
                    this.setCash(from, fromBalance);
                    response = new EconomyTransferResponse(this.getBalance(from), toBalance, 0.0, EconomyResponse.ResponseType.FAILURE, sendResponse.errorMessage);
                } else {
                    response = new EconomyTransferResponse(this.getBalance(from), this.getBalance(from), amount, EconomyResponse.ResponseType.SUCCESS, "");
                }
            }
        }
        return response;
    }
}

