/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.economy;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.file.FileConfiguration;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.economy.FileKey;
import org.divinitycraft.divinityeconomy.economy.players.EconomyPlayer;
import org.divinitycraft.divinityeconomy.lang.LangEntry;

public abstract class EconomyObject {
    protected static final BigDecimal MAX_DOUBLE = new BigDecimal(Double.MAX_VALUE);
    protected static final BigDecimal MIN_DOUBLE = new BigDecimal(Double.MIN_VALUE);
    protected static final MathContext ROUNDING_MC = MathContext.DECIMAL64;
    protected DEPlugin main;
    protected final File file;
    protected final File backupFile;
    protected FileConfiguration config;

    public EconomyObject(DEPlugin main, File file) {
        this.main = main;
        this.file = file;
        this.backupFile = EconomyObject.getBackupFile(file);
        this.loadConfig();
    }

    public DEPlugin getMain() {
        return this.main;
    }

    private void loadConfig() {
        boolean fileExists = this.fileExists();
        boolean backupFileExists = this.backupFileExists();
        if (!fileExists && !backupFileExists) {
            try {
                this.file.createNewFile();
                this.backupFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.config = this.getMain().getConfMan().readFile(this.file);
        } else {
            this.config = fileExists ? this.getMain().getConfMan().readFile(this.file) : this.getMain().getConfMan().readFile(this.backupFile);
        }
        this.save();
    }

    public double getBalanceAsDouble() {
        return this._getBalance().doubleValue();
    }

    public BigDecimal getBalance() {
        return this._getBalance();
    }

    public void setBalance(double balance) {
        this._setBalance(BigDecimal.valueOf(balance));
    }

    public void setBalance(BigDecimal balance) {
        this._setBalance(balance);
    }

    public double withdraw(double amount) {
        return this._withdraw(amount).doubleValue();
    }

    public double deposit(double amount) {
        return this._deposit(amount).doubleValue();
    }

    public boolean has(double amount) {
        return this._getBalance().compareTo(new BigDecimal(String.valueOf(amount))) >= 0;
    }

    public boolean canHave(double amount) {
        return EconomyPlayer.canHave(this._getBalance(), amount);
    }

    public String getName() {
        return this.getString(FileKey.NAME, null);
    }

    @Nullable
    public UUID getUUID() {
        String uuid = this.getString(FileKey.UUID, null);
        if (uuid == null) {
            return null;
        }
        return UUID.fromString(uuid);
    }

    @Nullable
    public String getUUIDAsString() {
        return this.getString(FileKey.UUID, null);
    }

    @Nullable
    public File getFile() {
        return this.file;
    }

    public boolean fileExists() {
        if (this.file == null) {
            return false;
        }
        return this.file.exists();
    }

    @Nullable
    public File getBackupFile() {
        return this.backupFile;
    }

    public boolean backupFileExists() {
        if (this.backupFile == null) {
            return false;
        }
        return this.backupFile.exists();
    }

    private BigDecimal scale(BigDecimal value) {
        return value.round(ROUNDING_MC).stripTrailingZeros();
    }

    private BigDecimal scale(double value) {
        return this.scale(new BigDecimal(String.valueOf(value)));
    }

    private BigDecimal _getBalance() {
        return this.scale(this.getDecimal(FileKey.BALANCE));
    }

    private void _setBalance(BigDecimal balance) {
        this.setAndSave(FileKey.BALANCE, this.scale(balance).toString());
    }

    private BigDecimal _withdraw(double amount) {
        this.setBalance(this._getBalance().subtract(this.scale(amount)));
        return this._getBalance();
    }

    private BigDecimal _deposit(double amount) {
        this.setBalance(this._getBalance().add(this.scale(amount)));
        return this._getBalance();
    }

    protected void clean() {
        for (String key : this.config.getKeys(false)) {
            if (key == null || this.checkKey(key)) continue;
            this.config.set(key, null);
        }
    }

    protected abstract boolean checkKey(@Nonnull String var1);

    @Nonnull
    protected BigDecimal parseDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            this.getMain().getConsole().warn(LangEntry.ECONOMY_IncorrectlyFormattedBalance.get(this.getMain()), this.file.getName());
            try {
                BigDecimal decimal = BigDecimal.valueOf(Double.parseDouble(value));
                this.getMain().getConsole().info(LangEntry.ECONOMY_RecoveredFile.get(this.getMain()), this.file.getName());
                return decimal;
            }
            catch (NumberFormatException e2) {
                this.getMain().getConsole().warn(LangEntry.ECONOMY_FailedToRecoverFile.get(this.getMain()), this.file.getName());
                return BigDecimal.ZERO;
            }
        }
    }

    @Nonnull
    protected BigDecimal getDecimal(@Nonnull FileKey key) {
        return this.parseDecimal(this.getString(key, BigDecimal.ZERO.toString()));
    }

    @Nonnull
    protected BigDecimal getDecimal(@Nonnull FileKey key, @Nullable String default_) {
        return this.parseDecimal(this.getString(key, default_));
    }

    @Nullable
    protected String getString(@Nonnull FileKey key, @Nullable String default_) {
        return String.valueOf(this.get(key, default_));
    }

    protected boolean getBoolean(@Nonnull FileKey key, boolean default_) {
        return (Boolean)this.get(key, default_);
    }

    @Nullable
    protected Object get(@Nonnull FileKey key, @Nullable Object default_) {
        Object value = this.config.get(key.getKey());
        if (value == null) {
            value = this.set(key, default_);
        }
        return value;
    }

    @Nonnull
    protected EconomyObject set(@Nonnull FileKey key, @Nullable Object value) {
        this.config.set(key.getKey(), value);
        return this;
    }

    @Nonnull
    protected EconomyObject setAndSave(@Nonnull FileKey key, @Nullable Object value) {
        this.set(key, value);
        this.save();
        return this;
    }

    protected void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.config.save(this.backupFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nonnull
    public static String getFilename(@Nonnull UUID uuid) {
        return EconomyObject.getFilename(uuid.toString());
    }

    @Nonnull
    public static String getFilename(@Nonnull String uuid) {
        return String.format("%s.yml", uuid);
    }

    @Nonnull
    public static File getBackupFile(@Nonnull File file) {
        return new File(file.getParentFile(), file.getName() + ".bak");
    }

    public static boolean canHave(BigDecimal balance, double amount) {
        return balance.add(BigDecimal.valueOf(amount)).compareTo(MAX_DOUBLE) < 0;
    }
}

