/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.economy.players;

import java.io.File;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.OfflinePlayer;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.economy.EconomyObject;
import org.divinitycraft.divinityeconomy.economy.FileKey;

public class EconomyPlayer
extends EconomyObject {
    private static final Set<FileKey> keys = Set.of(FileKey.NAME, FileKey.UUID, FileKey.BALANCE, FileKey.ENABLE_NOTIFICATIONS);
    private final OfflinePlayer player;

    public EconomyPlayer(DEPlugin main, File file, OfflinePlayer player) {
        super(main, file);
        this.player = player;
        this.get(FileKey.NAME, player.getName());
        this.get(FileKey.UUID, player.getUniqueId().toString());
        this.get(FileKey.BALANCE, this.getBalance().toString());
        this.get(FileKey.ENABLE_NOTIFICATIONS, true);
        this.clean();
        this.save();
    }

    public OfflinePlayer getPlayer() {
        return this.player;
    }

    @Override
    public String getName() {
        return (String)this.get(FileKey.NAME, this.getMain().getPlayMan().getPlayerName(this.player).name());
    }

    public boolean getNotification() {
        return this.getBoolean(FileKey.ENABLE_NOTIFICATIONS, true);
    }

    public void setNotification(boolean enable) {
        this.setAndSave(FileKey.ENABLE_NOTIFICATIONS, enable);
    }

    @Override
    public boolean checkKey(@Nonnull String key) {
        return keys.contains((Object)FileKey.get(key));
    }
}

