/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.help;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.DivinityModule;
import org.divinitycraft.divinityeconomy.help.Help;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.utils.ArrayUtils;

public class HelpManager
extends DivinityModule {
    final Map<String, Help> helpMap = new ConcurrentHashMap<String, Help>();
    final int maxHelpReturns = 50;
    final int maxHelpPerPage = 10;

    public HelpManager(DEPlugin main) {
        super(main);
    }

    @Override
    public void init() {
        this.loadHelp();
    }

    @Override
    public void deinit() {
    }

    public Help get(String command) {
        Help help = this.helpMap.get((command = command.toLowerCase().strip()).toLowerCase());
        if (help != null) {
            return help;
        }
        for (Help helpObject : this.helpMap.values()) {
            for (String alias : helpObject.getAliases()) {
                if (!alias.equalsIgnoreCase(command)) continue;
                return helpObject;
            }
        }
        return null;
    }

    public static Map<Integer, List<Help>> paginate(Help[] helpArray, int maxPerPage) {
        Map<Integer, List<Object>> pages = ArrayUtils.paginator(helpArray, maxPerPage);
        ConcurrentHashMap<Integer, List<Help>> helpPages = new ConcurrentHashMap<Integer, List<Help>>();
        for (Integer page : pages.keySet()) {
            helpPages.put(page, pages.get(page));
        }
        return helpPages;
    }

    public Help[] getAll(@Nullable String term) {
        if (term == null) {
            return this.helpMap.values().toArray(new Help[0]);
        }
        if (term.isEmpty()) {
            return this.helpMap.values().toArray(new Help[0]);
        }
        term = term.toLowerCase().strip();
        HashSet helpSet = new HashSet();
        ArrayList<Help> priority0ArrayList = new ArrayList<Help>();
        ArrayList<Help> priority1ArrayList = new ArrayList<Help>();
        ArrayList<Help> priority2ArrayList = new ArrayList<Help>();
        ArrayList<Help> priority3ArrayList = new ArrayList<Help>();
        ArrayList<Help> priority4ArrayList = new ArrayList<Help>();
        ArrayList<Help> priority5ArrayList = new ArrayList<Help>();
        int counter = 0;
        block0: for (Help help : this.helpMap.values()) {
            if (counter >= this.maxHelpReturns) break;
            String helpTitle = help.getCommand().toLowerCase().strip();
            String[] aliases = help.getAliases();
            String helpDescription = help.getDescription().toLowerCase().strip();
            if (helpTitle.equalsIgnoreCase(term)) {
                priority0ArrayList.add(help);
                ++counter;
                continue;
            }
            if (helpTitle.startsWith(term)) {
                priority1ArrayList.add(help);
                ++counter;
                continue;
            }
            if (helpTitle.contains(term)) {
                priority2ArrayList.add(help);
                ++counter;
                continue;
            }
            if (helpTitle.endsWith(term)) {
                priority3ArrayList.add(help);
                ++counter;
                continue;
            }
            if (helpDescription.contains(term)) {
                priority4ArrayList.add(help);
                ++counter;
            }
            for (String alias : aliases) {
                if (!alias.equalsIgnoreCase(term) && !alias.startsWith(term) && !alias.contains(term) && !alias.endsWith(term)) continue;
                priority5ArrayList.add(help);
                ++counter;
                continue block0;
            }
        }
        helpSet.addAll(priority0ArrayList);
        helpSet.addAll(priority1ArrayList);
        helpSet.addAll(priority2ArrayList);
        helpSet.addAll(priority3ArrayList);
        helpSet.addAll(priority4ArrayList);
        helpSet.addAll(priority5ArrayList);
        return helpSet.toArray(new Help[0]);
    }

    public String[] getAllNames(String term) {
        return (String[])Arrays.stream(this.getAll(term)).map(Help::getCommand).toArray(String[]::new);
    }

    public List<Help> getPage(String term, int page) {
        Map<Integer, List<Help>> pages = this.getPages(term);
        if (pages.containsKey(page)) {
            return pages.get(page);
        }
        if (pages.size() <= page) {
            return pages.get(pages.size());
        }
        return pages.get(1);
    }

    public Map<Integer, List<Help>> getPages(String term) {
        return HelpManager.paginate(this.getAll(term), this.maxHelpPerPage);
    }

    public void loadHelp() {
        Map commands = this.getMain().getDescription().getCommands();
        for (String command : commands.keySet()) {
            try {
                Map commandSection = (Map)commands.get(command);
                if (commandSection == null) {
                    this.getConsole().severe(LangEntry.HELP_NullEntry.get(this.getMain()), command);
                    continue;
                }
                String commandName = command.toLowerCase();
                this.helpMap.put(commandName, Help.fromConfig(commandName, commandSection));
            }
            catch (Exception e) {
                this.getConsole().severe(LangEntry.HELP_EntryError.get(this.getMain()), command, e.getMessage());
            }
        }
        this.getConsole().info(LangEntry.HELP_HelpLoaded.get(this.getMain()), this.helpMap.size());
    }
}

