/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.lang;

import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.DivinityModule;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.lang.ProvidedLangFile;

public class LangManager
extends DivinityModule {
    private static final File langFolder = new File("locale");
    private static final String defaultLangStr = ProvidedLangFile.en_GB.getPath();
    private static File defaultLangFile;
    private static FileConfiguration defaultConfig;
    private static File langFile;
    private static FileConfiguration langConfig;
    private boolean translateItems;
    private String desiredLang;

    public LangManager(DEPlugin main) {
        super(main);
    }

    public String getSelectedLangStats() {
        for (ProvidedLangFile providedLangFile : ProvidedLangFile.values()) {
            if (!langFile.getName().equals(providedLangFile.getPath())) continue;
            return providedLangFile.getName();
        }
        return String.format("Custom '%s'", langFile.getName());
    }

    @Override
    public void init() {
        boolean isUpdated = false;
        boolean isCreated = false;
        this.translateItems = this.getMain().getConfig().getBoolean(Setting.MAIN_TRANSLATE_ITEMS_BOOLEAN.path);
        this.desiredLang = this.getMain().getConfig().getString(Setting.MAIN_LANG_FILE_STRING.path);
        this.getConfMan().getFolder(langFolder.getPath());
        for (ProvidedLangFile providedLangFile : ProvidedLangFile.values()) {
            try {
                File thisLangFile = this.getConfMan().getFile(providedLangFile.getFilePath());
                FileConfiguration thisResourceFile = this.getConfMan().readResource(providedLangFile.getResourcePath());
                if (!thisLangFile.exists()) {
                    thisLangFile.createNewFile();
                    isCreated = true;
                }
                FileConfiguration thisLangConfig = this.getConfMan().readFile(thisLangFile);
                for (String key : thisResourceFile.getKeys(true)) {
                    int langCount;
                    int resourceCount;
                    if (!thisLangConfig.contains(key)) {
                        thisLangConfig.set(key, thisResourceFile.get(key));
                        isUpdated = true;
                        continue;
                    }
                    String resourceString = thisResourceFile.getString(key);
                    String langString = thisLangConfig.getString(key);
                    if (resourceString == null || langString == null || (resourceCount = resourceString.length() - resourceString.replace("%s", "").length()) == (langCount = langString.length() - langString.replace("%s", "").length())) continue;
                    thisLangConfig.set(key, (Object)resourceString);
                    isUpdated = true;
                }
                thisLangConfig.save(thisLangFile);
                if (isCreated) {
                    this.getConsole().info("Created lang file: %s.", providedLangFile.getPath());
                    continue;
                }
                if (!isUpdated) continue;
                this.getConsole().info("Updated lang file: %s.", providedLangFile.getPath());
            }
            catch (Exception e) {
                this.getConsole().severe("Couldn't update lang file: %s.", providedLangFile.getPath());
            }
        }
        for (File thisLangFile : this.getConfMan().getFolderFiles(langFolder.getPath())) {
            this.getConsole().debug("Found lang file: %s.", thisLangFile.getPath());
            if (!thisLangFile.getName().equals(this.desiredLang)) continue;
            langFile = thisLangFile;
            langConfig = this.getConfMan().readFile(langFile);
        }
        defaultLangFile = this.getConfMan().getFile(new File(langFolder, defaultLangStr).getPath());
        defaultConfig = this.getConfMan().readFile(defaultLangFile);
        if (langFile == null || langConfig == null) {
            this.getConsole().severe("Couldn't load lang file: %s.", this.desiredLang);
            langFile = defaultLangFile;
            langConfig = defaultConfig;
        }
        if (defaultConfig == null || !defaultLangFile.exists()) {
            this.getConsole().severe("Couldn't load default lang file: %s.", defaultLangStr);
        }
        this.getConsole().info("Loaded lang file: %s.", langFile.getName());
    }

    @Override
    public void deinit() {
    }

    public String get(LangEntry langEntry) {
        if (!defaultConfig.contains(langEntry.path)) {
            this.getConsole().warn("Lang entry not found in default lang file: %s.", langEntry.path);
        }
        if (langConfig == null) {
            return this.getDefault(langEntry);
        }
        if (!langConfig.contains(langEntry.path)) {
            this.getConsole().debug("Lang entry not found in selected lang file (%s): %s.", langFile.getName(), langEntry.path);
            return this.getDefault(langEntry);
        }
        return langConfig.getString(langEntry.path);
    }

    public String getDefault(LangEntry langEntry) {
        return defaultConfig.getString(langEntry.path, String.format("MISSING LANG ENTRY (%s)", langEntry.path));
    }

    public String get(LangEntry langEntry, Object ... args) {
        return String.format(this.get(langEntry), args);
    }

    public String getItemName(String text, String defaultText) {
        if (langConfig == null || !this.translateItems) {
            return this.getDefaultItemName(text, defaultText);
        }
        return langConfig.getString(text, this.getDefaultItemName(text, defaultText));
    }

    public String getDefaultItemName(String text, String defaultText) {
        return defaultConfig.getString(text, defaultText);
    }

    public String getSelectedLang() {
        return langFile.getName();
    }

    public String getDesiredLang() {
        return this.desiredLang;
    }

    public String getDefaultLang() {
        return defaultLangStr;
    }

    public boolean isUsingDefaultLang() {
        return langFile.getName().equals(defaultLangStr);
    }
}

