/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.mail;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.DivinityModule;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.mail.MailList;
import org.divinitycraft.divinityeconomy.mail.events.MailEvent;

public class MailManager
extends DivinityModule {
    private final String mailFile = "mail.yml";
    private Map<String, MailList> mailMap;
    private FileConfiguration configuration;
    private boolean enableMail;
    private boolean enableMailNotify;
    private boolean enableMailNotifySilent;

    public MailManager(DEPlugin main) {
        super(main);
    }

    @Override
    public void init() {
        this.enableMail = this.getMain().getConfMan().getBoolean(Setting.MAIL_ENABLE_BOOLEAN);
        this.enableMailNotify = this.getMain().getConfMan().getBoolean(Setting.MAIL_NOTIFY_BOOLEAN);
        this.enableMailNotifySilent = this.getMain().getConfMan().getBoolean(Setting.MAIL_NOTIFY_SILENT_BOOLEAN);
        if (this.enableMail) {
            this.setupMailFile();
            this.loadAllMail();
        }
        if (this.enableMailNotify && this.enableMail) {
            this.getMain().getServer().getPluginManager().registerEvents((Listener)new MailEvent(this.getMain(), this.enableMailNotifySilent), (Plugin)this.getMain());
        }
    }

    @Override
    public void deinit() {
        if (this.enableMail) {
            this.saveAllMail();
        }
    }

    public boolean isMailEnabled() {
        return this.enableMail;
    }

    public void setupMailFile() {
        this.readMailFile();
    }

    public FileConfiguration readMailFile() {
        return this.getConfMan().loadFile(this.mailFile);
    }

    public void loadAllMail() {
        this.configuration = this.getConfMan().loadFile(this.mailFile);
        this.mailMap = new ConcurrentHashMap<String, MailList>();
        int userCount = 0;
        int mailCount = 0;
        for (String userID : this.configuration.getKeys(false)) {
            ConfigurationSection mailListSection = this.configuration.getConfigurationSection(userID);
            MailList mailList = new MailList(userID, mailListSection);
            this.addMailList(userID, mailList);
            ++userCount;
            mailCount += mailList.getMailIDs().size();
        }
        this.getConsole().info(LangEntry.MAIL_MailLoaded.get(this.getMain()), mailCount, userCount);
    }

    public void addMailList(String uuid, MailList mailList) {
        this.mailMap.put(uuid, mailList);
        this.saveMailList(mailList);
    }

    public MailList addPlayer(String uuid) {
        ConfigurationSection mailSection = this.createMailListSection(uuid);
        MailList mailList = new MailList(uuid, mailSection);
        this.addMailList(uuid, mailList);
        return mailList;
    }

    public ConfigurationSection createMailListSection(String uuid) {
        return this.configuration.createSection(uuid);
    }

    public MailList getMailList(String uuid) {
        if (!this.enableMail) {
            return new MailList(uuid, null);
        }
        if (!this.mailMap.containsKey(uuid)) {
            this.addPlayer(uuid);
        }
        return this.mailMap.get(uuid);
    }

    private void setData(String key, Object value) {
        this.configuration.set(key, value);
    }

    public void saveMailList(MailList mailList) {
        mailList.saveAllMail();
        this.setData(mailList.getPlayer(), mailList.getConfigurationSection());
    }

    private void saveMailFile() {
        this.getConfMan().saveFile(this.configuration, this.mailFile);
    }

    public void saveAllMail() {
        int userCount = 0;
        int mailCount = 0;
        for (MailList mailList : this.mailMap.values()) {
            this.saveMailList(mailList);
            ++userCount;
            mailCount += mailList.getMailIDs().size();
        }
        this.saveMailFile();
        this.getConsole().info(LangEntry.MAIL_MailSaved.get(this.getMain()), mailCount, userCount);
    }
}

