/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market;

import org.bukkit.configuration.ConfigurationSection;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.DivinityModule;
import org.divinitycraft.divinityeconomy.market.MapKeys;
import org.divinitycraft.divinityeconomy.market.TokenManager;

public abstract class MarketableToken
extends DivinityModule {
    protected final ConfigurationSection itemConfig;
    protected final ConfigurationSection defaultItemConfig;
    protected final TokenManager tokenManager;
    protected final String ID;
    protected final String name;
    protected String error = "No Error";

    public MarketableToken(DEPlugin main, TokenManager tokenManager, String ID, ConfigurationSection config, ConfigurationSection defaultConfig) {
        super(main, false);
        this.itemConfig = config;
        this.defaultItemConfig = defaultConfig;
        this.tokenManager = tokenManager;
        this.ID = ID;
        this.name = this.getMain().getLang().getItemName(this.ID, this.ID);
    }

    @Override
    public void init() {
    }

    @Override
    public void deinit() {
    }

    public TokenManager getManager() {
        return this.tokenManager;
    }

    public String getID() {
        return this.ID;
    }

    public abstract boolean check();

    public String getError() {
        return this.error;
    }

    public ConfigurationSection getDefaultItemConfig() {
        return this.defaultItemConfig;
    }

    public ConfigurationSection getItemConfig() {
        return this.itemConfig;
    }

    public String getName() {
        return this.name;
    }

    public int getQuantity() {
        return this.itemConfig.getInt(MapKeys.QUANTITY.key);
    }

    protected void setQuantity(int amount) {
        this.setData(MapKeys.QUANTITY.key, amount);
    }

    protected void editQuantity(int amount) {
        this.setQuantity(this.getQuantity() + amount);
    }

    public int getDefaultQuantity() {
        return this.defaultItemConfig.getInt(MapKeys.QUANTITY.key);
    }

    public boolean getAllowed() {
        return this.itemConfig.getBoolean(MapKeys.ALLOWED.key);
    }

    public void setAllowed(boolean allowed) {
        this.setData(MapKeys.ALLOWED.key, allowed);
    }

    public boolean has(int amount) {
        return this.getQuantity() >= amount;
    }

    private void setData(String key, Object value) {
        this.itemConfig.set(key, value);
    }
}

