/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.milkbowl.vault.economy.EconomyResponse;
import org.divinitycraft.divinityeconomy.market.MarketableToken;
import org.divinitycraft.divinityeconomy.response.ValueResponse;

public class TokenValueResponse
extends ValueResponse {
    Map<MarketableToken, Integer> quantities = new ConcurrentHashMap<MarketableToken, Integer>();
    Map<MarketableToken, Double> values = new ConcurrentHashMap<MarketableToken, Double>();
    Map<String, MarketableToken> tokenIdMap = new ConcurrentHashMap<String, MarketableToken>();
    int totalQuantity = 0;

    public TokenValueResponse() {
    }

    public TokenValueResponse(EconomyResponse.ResponseType type, String message) {
        super(type, message);
    }

    protected TokenValueResponse addToken(MarketableToken token, int quantity, double value) {
        this.tokenIdMap.put(token.getID(), token);
        return this.addQuantity(token, quantity).addValue(token, value);
    }

    public TokenValueResponse addResponse(TokenValueResponse response) {
        for (MarketableToken token : response.getTokens()) {
            this.addToken(token, response.getQuantity(token), response.getValue(token));
        }
        if (response.isFailure()) {
            this.setFailure(response.getErrorMessage());
        }
        return this;
    }

    public int getQuantity() {
        return this.totalQuantity;
    }

    public Map<MarketableToken, Integer> getQuantities() {
        return this.quantities;
    }

    public int getQuantity(@Nonnull MarketableToken token) {
        return this.quantities.getOrDefault(token, 0);
    }

    public int getQuantity(@Nonnull String id) {
        MarketableToken token = this.getTokenById(id);
        if (token == null) {
            return 0;
        }
        return this.getQuantity(token);
    }

    public Map<MarketableToken, Double> getValues() {
        return this.values;
    }

    public double getValue(@Nonnull MarketableToken token) {
        return this.values.getOrDefault(token, 0.0);
    }

    public double getValue(@Nonnull String id) {
        MarketableToken token = this.getTokenById(id);
        if (token == null) {
            return 0.0;
        }
        return this.getValue(token);
    }

    public MarketableToken getTokenById(String id) {
        return this.tokenIdMap.getOrDefault(id, null);
    }

    public boolean hasToken(String id) {
        return this.tokenIdMap.containsKey(id);
    }

    public boolean hasToken(MarketableToken token) {
        return this.tokenIdMap.containsValue(token);
    }

    public List<MarketableToken> getTokens() {
        return new ArrayList<MarketableToken>(this.tokenIdMap.values());
    }

    public List<String> getTokenIds() {
        return new ArrayList<String>(this.tokenIdMap.keySet());
    }

    private TokenValueResponse addQuantity(MarketableToken token, int quantity) {
        this.quantities.put(token, this.quantities.getOrDefault(token, 0) + quantity);
        this.totalQuantity += quantity;
        return this;
    }

    private TokenValueResponse addValue(MarketableToken token, double value) {
        this.values.put(token, this.values.getOrDefault(token, 0.0) + value);
        this.addValue(value);
        return this;
    }

    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (MarketableToken token : this.getTokens()) {
            names.add(token.getName());
        }
        return names;
    }

    public String listNames() {
        return String.join((CharSequence)", ", this.getNames());
    }

    public String listNames(String prefix) {
        return String.format("%s %s", prefix, String.join((CharSequence)", ", this.getNames()));
    }

    @Override
    public String toString() {
        return String.format("TokenValueResponse{ type=%s, message=%s, quantity=%d, value=%f }", this.getResponseType(), this.getErrorMessage(), this.getQuantity(), this.getValue());
    }
}

