/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.exp;

import java.util.concurrent.ConcurrentHashMap;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.MarketableToken;
import org.divinitycraft.divinityeconomy.market.TokenManager;
import org.divinitycraft.divinityeconomy.market.exp.Exp;
import org.divinitycraft.divinityeconomy.response.ValueResponse;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class ExpManager
extends TokenManager {
    private final int maxTradableExp = 100000;
    private final int minTradableExp = 1;

    public ExpManager(DEPlugin main) {
        super(main, "experience.yml", null, new ConcurrentHashMap());
    }

    @Override
    public void init() {
        this.saveMessagesDisabled = this.getConfMan().getBoolean(Setting.IGNORE_SAVE_MESSAGE_BOOLEAN);
        this.buyScale = this.getConfMan().getDouble(Setting.MARKET_EXP_BUY_TAX_FLOAT);
        this.sellScale = this.getConfMan().getDouble(Setting.MARKET_EXP_SELL_TAX_FLOAT);
        this.baseQuantity = this.getConfMan().getInt(Setting.MARKET_EXP_BASE_QUANTITY_INTEGER).intValue();
        this.dynamicPricing = this.getConfMan().getBoolean(Setting.MARKET_EXP_DYN_PRICING_BOOLEAN);
        this.wholeMarketInflation = this.getConfMan().getBoolean(Setting.MARKET_EXP_WHOLE_MARKET_INF_BOOLEAN);
        this.maxItemValue = this.getConfMan().getDouble(Setting.MARKET_MAX_ITEM_VALUE_DOUBLE);
        if (this.maxItemValue < 0.0) {
            this.maxItemValue = Double.MAX_VALUE;
        }
        this.minItemValue = this.getConfMan().getDouble(Setting.MARKET_MIN_ITEM_VALUE_DOUBLE);
        if (this.minItemValue < 0.0) {
            this.minItemValue = Double.MIN_VALUE;
        }
        int timer = Converter.getTicks(this.getConfMan().getInt(Setting.MARKET_SAVE_TIMER_INTEGER));
        this.saveTimer = new BukkitRunnable(){

            public void run() {
                ExpManager.this.saveItems();
            }
        };
        this.saveTimer.runTaskTimerAsynchronously((Plugin)this.getMain(), (long)timer, (long)timer);
        this.loadItems();
        this.loadAliases();
    }

    @Override
    public void deinit() {
        this.saveTimer.cancel();
        this.saveItems();
    }

    public int getMaxTradableExp() {
        return this.maxTradableExp;
    }

    public int getMinTradableExp() {
        return this.minTradableExp;
    }

    @Override
    public String getType() {
        return "EXPERIENCE";
    }

    public ValueResponse getBuyValue(long amount) {
        if (amount <= 0L) {
            return new ValueResponse(0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.EXPERIENCE_InvalidAmount.get(this.getMain()));
        }
        Exp exp = this.getExperience();
        if (!exp.getAllowed()) {
            return new ValueResponse(0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.EXPERIENCE_IsBanned.get(this.getMain()));
        }
        if (amount > (long)exp.getQuantity()) {
            return new ValueResponse(0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.EXPERIENCE_NotEnoughExperienceToBuy.get(this.getMain()));
        }
        double price = this.calculatePrice(amount, exp.getQuantity(), this.buyScale, true);
        if (price < 0.0) {
            return new ValueResponse(0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.EXPERIENCE_IsWorthless.get(this.getMain()));
        }
        return new ValueResponse(price, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public String getBuyValueString(long amount) {
        ValueResponse response = this.getBuyValue(amount);
        if (response.isFailure()) {
            return String.format("Error: %s", response.getErrorMessage());
        }
        return String.format("Value: %s", this.getConsole().formatMoney(response.getValue()));
    }

    public ValueResponse getSellValue(long amount, Player player) {
        if (amount > (long)ExpManager.getPlayerExp(player)) {
            return new ValueResponse(0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.EXPERIENCE_NotEnoughExperienceToSell.get(this.getMain()));
        }
        return this.getSellValue(amount);
    }

    public ValueResponse getSellValue(long amount) {
        if (amount <= 0L) {
            return new ValueResponse(0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.EXPERIENCE_InvalidAmount.get(this.getMain()));
        }
        Exp exp = this.getExperience();
        if (!exp.getAllowed()) {
            return new ValueResponse(0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.EXPERIENCE_IsBanned.get(this.getMain()));
        }
        double price = this.calculatePrice(amount, exp.getQuantity(), this.sellScale, false);
        if (price < 0.0) {
            return new ValueResponse(0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.EXPERIENCE_IsWorthless.get(this.getMain()));
        }
        return new ValueResponse(price, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public String getSellValueString(long amount, Player player) {
        ValueResponse response = this.getSellValue(amount, player);
        if (response.isFailure()) {
            return String.format("Error: %s", response.getErrorMessage());
        }
        return String.format("Value: %s", this.getConsole().formatMoney(response.getValue()));
    }

    public int addExperience(Player player, int amount) {
        Exp exp = this.getExperience();
        if (exp == null) {
            return 0;
        }
        exp.remQuantity(amount);
        return ExpManager.changePlayerExp(player, amount);
    }

    public int remExperience(Player player, int amount) {
        Exp exp = this.getExperience();
        if (exp == null) {
            return 0;
        }
        exp.addQuantity(amount);
        return ExpManager.changePlayerExp(player, -amount);
    }

    public Exp getExperience() {
        return (Exp)this.getItem("experience");
    }

    @Override
    public void loadAliases() {
    }

    @Override
    public MarketableToken loadItem(String ID, ConfigurationSection data, ConfigurationSection defaultData) {
        return new Exp(this.getMain(), this, ID, data, defaultData);
    }

    public static int getExpToLevelUp(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    public static int getExpAtLevel(int level) {
        if (level <= 16) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level <= 31) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }

    public static int getPlayerExp(Player player) {
        int exp = 0;
        int level = player.getLevel();
        exp += ExpManager.getExpAtLevel(level);
        return exp += Math.round((float)ExpManager.getExpToLevelUp(level) * player.getExp());
    }

    public static int changePlayerExp(Player player, int exp) {
        int currentExp = ExpManager.getPlayerExp(player);
        player.setExp(0.0f);
        player.setLevel(0);
        int newExp = currentExp + exp;
        player.giveExp(newExp);
        return newExp;
    }
}

