/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.market.TokenManager;
import org.divinitycraft.divinityeconomy.market.TokenValueResponse;
import org.divinitycraft.divinityeconomy.market.items.MarketableItem;
import org.divinitycraft.divinityeconomy.market.items.enchants.EnchantManager;

public abstract class ItemManager
extends TokenManager {
    public ItemManager(DEPlugin main, String itemFile, String aliasFile, Map<String, ? extends MarketableItem> itemMap) {
        super(main, itemFile, aliasFile, itemMap);
    }

    public static boolean itemIsNamed(@Nonnull ItemStack itemStack) {
        return itemStack.getItemMeta().hasDisplayName();
    }

    public static boolean itemHasLore(@Nonnull ItemStack itemStack) {
        return itemStack.getItemMeta().hasLore();
    }

    public static ItemStack[] removeEnchantedItems(ItemStack[] itemStacks) {
        ArrayList nonEnchanted = new ArrayList();
        Arrays.stream(itemStacks).forEach(stack -> {
            if (EnchantManager.getEnchantments(stack).isEmpty()) {
                nonEnchanted.add(stack);
            } else {
                EnchantmentStorageMeta meta;
                ItemMeta patt0$temp = stack.getItemMeta();
                if (patt0$temp instanceof EnchantmentStorageMeta && (meta = (EnchantmentStorageMeta)patt0$temp).getStoredEnchants().isEmpty()) {
                    nonEnchanted.add(stack);
                }
            }
        });
        return nonEnchanted.toArray(new ItemStack[0]);
    }

    public static ItemStack[] removeNamedItems(ItemStack[] itemStacks) {
        ArrayList nonNamed = new ArrayList();
        Arrays.stream(itemStacks).forEach(stack -> {
            if (!ItemManager.itemIsNamed(stack) && !ItemManager.itemHasLore(stack)) {
                nonNamed.add(stack);
            }
        });
        return nonNamed.toArray(new ItemStack[0]);
    }

    public static ItemStack[] cloneItems(ItemStack[] itemStacks) {
        ArrayList clones = new ArrayList();
        Arrays.stream(itemStacks).forEach(stack -> clones.add(ItemManager.clone(stack)));
        return clones.toArray(new ItemStack[0]);
    }

    public static ItemStack clone(ItemStack itemStack) {
        ItemStack newItemStack = new ItemStack(itemStack.getType(), itemStack.getAmount());
        newItemStack.setItemMeta(itemStack.getItemMeta());
        newItemStack.addUnsafeEnchantments(EnchantManager.getEnchantments(itemStack));
        return newItemStack;
    }

    public static int getMaterialCount(ItemStack[] iStacks) {
        int count = 0;
        for (ItemStack iStack : iStacks) {
            count += iStack.getAmount();
        }
        return count;
    }

    public static boolean itemIsUnidentified(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        return container.has(NamespacedKey.minecraft((String)"de-uuid"), PersistentDataType.STRING);
    }

    public static String getIdentity(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        return (String)container.get(NamespacedKey.minecraft((String)"de-uuid"), PersistentDataType.STRING);
    }

    public static void generateIdentity(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        container.set(NamespacedKey.minecraft((String)"de-uuid"), PersistentDataType.STRING, (Object)UUID.randomUUID().toString());
        itemStack.setItemMeta(itemMeta);
    }

    public static String getOrSetIdentity(ItemStack itemStack) {
        if (ItemManager.itemIsUnidentified(itemStack)) {
            return ItemManager.getIdentity(itemStack);
        }
        ItemManager.generateIdentity(itemStack);
        return ItemManager.getIdentity(itemStack);
    }

    public static List<ItemStack> removeIdentity(List<ItemStack> itemStacks) {
        ArrayList<ItemStack> nonIdentified = new ArrayList<ItemStack>();
        for (ItemStack itemStack : itemStacks) {
            nonIdentified.add(ItemManager.removeIdentity(itemStack));
        }
        return nonIdentified;
    }

    public static ItemStack removeIdentity(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        container.remove(NamespacedKey.minecraft((String)"de-uuid"));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public abstract Set<String> getItemNames(ItemStack var1);

    public abstract Set<String> getItemNames(ItemStack var1, String var2);

    public abstract TokenValueResponse getSellValue(ItemStack[] var1);

    public abstract TokenValueResponse getSellValue(ItemStack var1, int var2);

    public abstract TokenValueResponse getBuyValue(ItemStack[] var1);

    public abstract TokenValueResponse getBuyValue(ItemStack var1, int var2);
}

