/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items.enchants;

import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.market.MapKeys;
import org.divinitycraft.divinityeconomy.market.items.MarketableItem;
import org.divinitycraft.divinityeconomy.market.items.enchants.EnchantManager;

public class MarketableEnchant
extends MarketableItem {
    private final Enchantment enchantment;

    public MarketableEnchant(DEPlugin main, EnchantManager itemManager, String ID, ConfigurationSection config, ConfigurationSection defaultConfig) {
        super(main, itemManager, ID, config, defaultConfig);
        Enchantment enchantment = null;
        try {
            enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.fromString((String)config.getString(MapKeys.ENCHANT_ID.key)));
        }
        catch (IllegalArgumentException e) {
            this.error = e.getMessage();
        }
        this.enchantment = enchantment;
    }

    public static int levelsToBooks(int currentLevels, int newLevels) {
        int currentBooks = currentLevels == 1 ? 1 : (int)Math.pow(2.0, currentLevels);
        int newBooks = newLevels == 1 ? 1 : (int)Math.pow(2.0, newLevels);
        int delta = currentLevels == 0 ? newBooks : (newLevels == 0 ? currentBooks : newBooks - currentBooks);
        if (delta > 0) {
            return delta;
        }
        return -delta;
    }

    @Override
    public EnchantManager getManager() {
        return (EnchantManager)super.getManager();
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    @Override
    public boolean has(int levels) {
        return this.getQuantity() >= MarketableEnchant.levelsToBooks(0, levels);
    }

    public Enchantment getEnchant() {
        return this.enchantment;
    }

    public int getMaxLevel() {
        return this.itemConfig.getInt(MapKeys.MAX_LEVEL.key);
    }

    @Override
    public boolean check() {
        return this.enchantment != null;
    }
}

