/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items.materials;

import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.market.MapKeys;
import org.divinitycraft.divinityeconomy.market.items.ItemManager;
import org.divinitycraft.divinityeconomy.market.items.MarketableItem;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialManager;
import org.divinitycraft.divinityeconomy.player.PlayerManager;

public abstract class MarketableMaterial
extends MarketableItem {
    protected final Material material;

    public MarketableMaterial(DEPlugin main, MaterialManager itemManager, String ID, ConfigurationSection config, ConfigurationSection defaultConfig) {
        super(main, itemManager, ID, config, defaultConfig);
        Material material;
        try {
            material = Material.valueOf((String)config.getString(MapKeys.MATERIAL_ID.key, ID));
        }
        catch (IllegalArgumentException | NullPointerException exception) {
            material = null;
        }
        this.material = material;
    }

    @Override
    public MaterialManager getManager() {
        return (MaterialManager)this.tokenManager;
    }

    public Material getMaterial() {
        return this.material;
    }

    public abstract ItemStack getItemStack(int var1);

    public abstract boolean equals(MarketableMaterial var1);

    public abstract boolean equals(ItemStack var1);

    public ItemStack[] getItemStacks(int amount) {
        int maxStackSize = this.getMaterial().getMaxStackSize();
        int stacks = (int)Math.ceil((double)amount / (double)maxStackSize);
        ItemStack[] itemStacks = new ItemStack[stacks];
        for (int i = 0; i < stacks && amount > 0; amount -= maxStackSize, ++i) {
            itemStacks[i] = this.getItemStack(Math.min(maxStackSize, amount));
        }
        return itemStacks;
    }

    public ItemStack[] getMaterialSlots(Player player) {
        HashMap inventory = player.getInventory().all(this.material);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : inventory.values()) {
            if (!this.equals(itemStack)) continue;
            itemStacks.add(itemStack);
        }
        return itemStacks.toArray(new ItemStack[0]);
    }

    public int getMaterialCount(Player player) {
        return ItemManager.getMaterialCount(this.getMaterialSlots(player));
    }

    public int getAvailableSpace(Player player) {
        int emptySlots = PlayerManager.getEmptySlots(player);
        ItemStack[] iStacks = this.getMaterialSlots(player);
        int materialCount = ItemManager.getMaterialCount(iStacks);
        int availableSpace = 0;
        availableSpace += iStacks.length * this.material.getMaxStackSize() - materialCount;
        return availableSpace += emptySlots * this.material.getMaxStackSize();
    }

    public ItemStack[] getMaterialSlotsToCount(Player player, int amount) {
        ItemStack[] materialStacks = this.getMaterialSlots(player);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        int amountLeft = amount;
        for (ItemStack materialStack : materialStacks) {
            ItemStack itemStack;
            int stackAmount = materialStack.getAmount();
            if (amountLeft >= stackAmount) {
                itemStack = materialStack;
            } else {
                itemStack = this.getItemStack(amountLeft);
                itemStack.setItemMeta(materialStack.getItemMeta());
                materialStack.setAmount(stackAmount - amountLeft);
            }
            itemStacks.add(itemStack);
            if ((amountLeft -= itemStack.getAmount()) == 0) break;
        }
        return itemStacks.toArray(new ItemStack[0]);
    }

    public ItemStack[] addPlayerMaterials(Player player, int amount) {
        ItemStack[] itemStacks = this.getItemStacks(amount);
        PlayerManager.addPlayerItems(player, itemStacks);
        return itemStacks;
    }

    public void removePlayerMaterials(Player player, int amount) {
        ItemStack[] itemStacks = this.getMaterialSlotsToCount(player, amount);
        PlayerManager.removePlayerItems(itemStacks);
    }

    public int getStackCount(int amount) {
        int itemPerStack = this.material.getMaxStackSize();
        return (int)Math.ceil((double)amount / (double)itemPerStack);
    }
}

