/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items.materials;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.market.MarketableToken;
import org.divinitycraft.divinityeconomy.market.TokenValueResponse;
import org.divinitycraft.divinityeconomy.market.items.ItemManager;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;

public class MaterialValueResponse
extends TokenValueResponse {
    private final Map<MarketableMaterial, ArrayList<ItemStack>> itemStackMap = new ConcurrentHashMap<MarketableMaterial, ArrayList<ItemStack>>();
    private final ArrayList<ItemStack> itemStacks = new ArrayList();
    private final ArrayList<String> itemStackIDs = new ArrayList();
    private final ArrayList<ItemStack> clones = new ArrayList();

    public MaterialValueResponse() {
    }

    public MaterialValueResponse(EconomyResponse.ResponseType type, String message) {
        super(type, message);
    }

    public MaterialValueResponse addToken(MarketableMaterial token, int quantity, double value, ItemStack[] itemStacks) {
        super.addToken(token, quantity, value);
        return this.addItemStacks(token, itemStacks);
    }

    public MaterialValueResponse addResponse(MaterialValueResponse response) {
        for (MarketableToken token : response.getTokens()) {
            this.addToken((MarketableMaterial)token, response.getQuantity(token), response.getValue(token), response.getItemStacksAsArray(token));
        }
        if (response.isFailure()) {
            this.setFailure(response.getErrorMessage());
        }
        return this;
    }

    public List<ItemStack> getItemStacks() {
        return ItemManager.removeIdentity(new ArrayList<ItemStack>(this.itemStacks));
    }

    public ItemStack[] getItemStacksAsArray() {
        return this.getItemStacks().toArray(new ItemStack[0]);
    }

    public List<ItemStack> getClones() {
        return ItemManager.removeIdentity(new ArrayList<ItemStack>(this.clones));
    }

    public ItemStack[] getClonesAsArray() {
        return this.getClones().toArray(new ItemStack[0]);
    }

    @Nonnull
    public List<ItemStack> getItemStacks(@Nonnull MarketableToken token) {
        return ItemManager.removeIdentity(new ArrayList<ItemStack>(this.itemStackMap.getOrDefault(token, new ArrayList())));
    }

    @Nonnull
    public ItemStack[] getItemStacksAsArray(@Nonnull MarketableToken token) {
        return this.getItemStacks(token).toArray(new ItemStack[0]);
    }

    @Nonnull
    public List<ItemStack> getItemStacks(@Nonnull String id) {
        MarketableToken token = this.getTokenById(id);
        if (token == null) {
            return new ArrayList<ItemStack>();
        }
        return this.getItemStacks(token);
    }

    @Nonnull
    public ItemStack[] getItemStacksAsArray(@Nonnull String id) {
        return this.getItemStacks(id).toArray(new ItemStack[0]);
    }

    private MaterialValueResponse addItemStacks(MarketableMaterial token, ItemStack[] itemStacks) {
        for (ItemStack itemStack : itemStacks) {
            this.addItemStack(token, itemStack);
        }
        return this;
    }

    private MaterialValueResponse addItemStack(MarketableMaterial token, ItemStack itemStack) {
        String id = ItemManager.getOrSetIdentity(itemStack);
        if (!this.itemStackIDs.contains(id)) {
            ArrayList<ItemStack> itemStacks = this.itemStackMap.getOrDefault(token, new ArrayList());
            itemStacks.add(itemStack);
            this.itemStackMap.put(token, itemStacks);
            this.itemStackIDs.add(id);
            this.itemStacks.add(itemStack);
            this.clones.add(ItemManager.clone(itemStack));
        }
        return this;
    }

    public void cleanup() {
        for (ItemStack itemStack : this.itemStacks) {
            ItemManager.removeIdentity(itemStack);
        }
    }
}

