/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items.materials.entity;

import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.market.MapKeys;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.entity.EntityManager;
import org.divinitycraft.divinityeconomy.market.items.materials.entity.NBTFuncs;

public class MarketableEntity
extends MarketableMaterial {
    private final EntityType entityType;

    public MarketableEntity(DEPlugin main, EntityManager itemManager, String ID, ConfigurationSection config, ConfigurationSection defaultConfig) {
        super(main, itemManager, ID, config, defaultConfig);
        EntityType entityType = null;
        try {
            String entityId = config.getString(MapKeys.ENTITY_ID.key);
            if (entityId != null) {
                entityType = EntityType.valueOf((String)entityId);
            }
        }
        catch (IllegalArgumentException exception) {
            this.error = exception.getMessage();
        }
        this.entityType = entityType;
    }

    @Override
    public boolean check() {
        return this.entityType != null;
    }

    public EntityType getEntity() {
        return this.entityType;
    }

    @Override
    public ItemStack getItemStack(int amount) {
        BlockStateMeta blockStateMeta;
        BlockState blockState;
        ItemStack itemStack = new ItemStack(this.material, amount);
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof BlockStateMeta && (blockState = (blockStateMeta = (BlockStateMeta)meta).getBlockState()) instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            spawner.setSpawnedType(this.entityType);
            spawner.setDelay(20);
            spawner.setMinSpawnDelay(200);
            spawner.setMaxSpawnDelay(800);
            spawner.setSpawnCount(4);
            spawner.setMaxNearbyEntities(6);
            spawner.setRequiredPlayerRange(16);
            spawner.setSpawnRange(4);
            NBTFuncs.setSpawnerTag(this.getMain(), spawner);
            spawner.update();
            blockStateMeta.setBlockState((BlockState)spawner);
            itemStack.setItemMeta((ItemMeta)blockStateMeta);
        }
        return itemStack;
    }

    @Override
    public boolean equals(MarketableMaterial material) {
        if (material instanceof MarketableEntity) {
            MarketableEntity entity = (MarketableEntity)material;
            return this.getMaterial().equals((Object)entity.getMaterial()) && this.getEntity().equals((Object)entity.getEntity());
        }
        return false;
    }

    @Override
    public boolean equals(ItemStack itemStack) {
        BlockStateMeta blockStateMeta;
        BlockState blockState;
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof BlockStateMeta && (blockState = (blockStateMeta = (BlockStateMeta)itemMeta).getBlockState()) instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            return spawner.getSpawnedType().equals((Object)this.getEntity());
        }
        return false;
    }
}

